var bPageIsLoaded = false;
/***********************************************************************
*
* setCookie -	Generic Set Cookie routine
*
* Input: sName	 -	Name of cookie to create
*	 sValue	 -	Value to assign to the cookie
*	 sExpire -	Cookie expiry date/time (optional)
*
* Returns: null
*
************************************************************************/

function setCookie(sName, sValue, sExpire) 
    {
    var sCookie = sName + "=" + escape(sValue) +"; path=/";	// construct the cookie
    if (sExpire)
    	{
    	sCookie += "; expires=" + sExpire.toGMTString();	// add expiry date if present
    	}
    document.cookie = sCookie;					// store the cookie
    return null;
    }

/***********************************************************************
*
* getCookie	-	Generic Get Cookie routine
*
* Input: sName	-	Name of cookie to retrieve
*
* Returns:		Requested cookie or null if not found
*
************************************************************************/

function getCookie(sName) 
    {
    var sCookiecrumbs = document.cookie.split("; "); 	// break cookie into crumbs array
    var sNextcrumb
    for (var i=0; i < sCookiecrumbs.length; i++) 
	{
	sNextcrumb = sCookiecrumbs[i].split("=");	// break into name and value
	if (sNextcrumb[0] == sName)			// if name matches
	    {
	     return unescape(sNextcrumb[1]); 		// return value
	    }
	}
	return null;
    }

/***********************************************************************
*
* saveReferrer -	Saves the referrer to a Cookie
*
* Input: 		nothing
*
* Returns:		null
*
************************************************************************/

function saveReferrer() 
    {
    var bSetCookie = false;
    if (parent.frames.length == 0)					// No FrameSet
		{
		bSetCookie = true;
		}
    else														// FrameSet in use
		{
		var bCatalogFrameSet = false;
		for (var nFrameId = parent.frames.length; nFrameId > 0; nFrameId--)
			{
			if (parent.frames[nFrameId - 1].name == 'CatalogBody')	// Catalog FrameSet used
				{
				bCatalogFrameSet = true;
				break;
				}
			}
		if (bCatalogFrameSet)							// Catalog FrameSet
			{
			if (window.name=='CatalogBody')			// and this is the CatalogBody frame
				{
				bSetCookie = true;
				}
			}
		else													// Not Catalog FrameSet
			{
			bSetCookie = true;
			}
		}
    if (bSetCookie)
		{
		var sUrl = document.URL;
		var nHashPos = sUrl.lastIndexOf("#");		// Look for URL anchor
		if (nHashPos > 0)									// if it exists
		    {
		    sUrl = sUrl.substring(0,nHashPos);		// then remove it
		    }
		setCookie("ACTINIC_REFERRER", sUrl);		// Emulates HTTP_REFERER
		}
	    return null;
	    }
    
saveReferrer();						// For v6 only, should be in templates for v7

/***********************************************************************
*
* CreateArray	creates an array with n elements
*
* Input: n	-	number of elements
*
* Returns:		the created array
*
************************************************************************/

function CreateArray(n)
	{
	this.length = n;
	for (var i=1; i <= n; i++)							// for all ns
		{
		this[i] = new Section();						// create a section structure
		}
	return this;											// return the created array
	}

/***********************************************************************
*
* Section	-	creates the section structure for raw section lists
*
* Input: 				nothing
*
* Returns:				nothing
************************************************************************/

function Section()
	{
	this.sURL = null;
	this.sName = null;
	this.sImage = null;
	this.nImageWidth = null;
	this.nImageHeight= null;
	this.nSectionId	= null;
	this.pChild = null;
	}
	
/***********************************************************************
*
* SwapImage			-	swaps an image to the alternative
*
* Input:	sName		-	name of the image
*
*			sAltImage	-	filename of the alternative image
*
************************************************************************/

function SwapImage(sName, sAltImage)
	{
	var nCount = 0;
	document.aSource = new Array;						// array for images
	if (document[sName] != null)						// if image name exists
		{
		document.aSource[nCount++] = document[sName];	// store image
		if(null == document[sName].sOldSrc)
			{
			document[sName].sOldSrc = document[sName].src;	// store image source
			}
		document[sName].src = sAltImage;				// change image source to alternative
		}
	}

/***********************************************************************
*
* RestoreImage		-	restores an image to the original
*
* Input: 				nothing
*
* Returns:				nothing
************************************************************************/

function RestoreImage()
	{
	var nCount, aSource = document.aSource;
	if (aSource != null)									// if array of images exists
		{
		for(nCount=0; nCount < aSource.length; nCount++)	// restore all images
			{
			if ((aSource[nCount] != null) &&
				(aSource[nCount].sOldSrc != null))	// if we stored something for this image
				{
				aSource[nCount].src = aSource[nCount].sOldSrc;	// restore the original image
				}
			}
		}
	}

/***********************************************************************
*
* PreloadImages		-	restores an image to the original
*
* Input: 				nothing
*
* Returns:				nothing
*
************************************************************************/

function PreloadImages()
	{
	bPageIsLoaded = true;
	if(document.images)
		{
		if(!document.Preloaded)							// preload array defined?
			{
			document.Preloaded = new Array();		// no, define it
			}
		var nCounter , nLen = document.Preloaded.length, saArguments = PreloadImages.arguments;
		for(nCounter = 0; nCounter < saArguments.length; nCounter++)	// iterate through arguments
			{
			document.Preloaded[nLen] = new Image;
			document.Preloaded[nLen++].src = saArguments[nCounter];
			}
   	}
	}
	
/***********************************************************************
*
* ShowPopUp		-	creates pop up window
*
* Input: sUrl		-	URL o page to display
*			nWidth	-	Width of window
*			nHeight	-	Height of window
*
* Returns:				nothing
*
************************************************************************/

function ShowPopUp(sUrl, nWidth, nHeight)
  	{  
	window.open(sUrl, 'ActPopup', 'width=' + nWidth + ',height=' + nHeight + ',scrollbars, resizable');
	if (!bPageIsLoaded)
		{
		window.location.reload(true);
		}
	}

// START Norcat additional code
// Image Map and Image List code.
function addxy(choice,row,col){
// look through all forms 'till one containing field choice
 var tf = -1;
 var df = document.forms;
 var i = df.length - 1;
 for ( var j = 0; j <= i; j++)
  {
  var k = df[j].length - 1; 
  for ( var l = 0; l <= k; l++) if ( df[j].elements[l].name == (choice) ) tf = j;
  }
 if ( tf < 0 ) alert('Cannot find product form');

 var e = df[tf].elements;

  for (var i = 0; i < e.length; i++)
    {
    if ((e[i].type == 'hidden') && (e[i].value == 'Add')) e[i].value = '';
    if (e[i].name == choice) e[i].value = 'Add';
    if (e[i].name == 'v_' + choice + '_1') e[i].value = row;
    if (e[i].name == 'v_' + choice + '_2') e[i].value = col;
    }
 df[tf].submit();
}
// END Norcat additional code


// START Norcat Select Code
function CreateColSize(cols, sizes){
// create an empty object holding the colour size range
  this.length = cols;
  this.index = 0;
  this.sizes = sizes;
  for (var i=0; i < cols; i++)						
    {
    this[i] = new SizeRange(sizes);
    }
  return this;	
}

function SizeRange(sizes){
// add a colour name and size range to CreateColSize object 
  this.colour = '';
  this.image = '';
  this.width = 0;
  this.height = 0;
  this.sizes = new Array();
}

function AddSizeRange(ref, colour, image, width, height, sizes){
// add a colour name and size range to the list
  var item = eval('x' + ref);
  var current = item.index;
  item[current].colour = colour;
  item[current].image = image;
  item[current].width = width;
  item[current].height = height;
  item[current].sizes = sizes;
  current++;
  item.index = current
}

function ShowSizeRange(ref){
// diagnostic display the colour size matrix
  var scaledown = 2;
  var showimage = true;
  var item = eval('x' + ref);
  document.write('<table border=1 cellspacing=0 cellpadding=2>');
  for ( var i = 0; i < item.length; i++ )
    {
    if ( showimage && (item[i].image != '') ) 
      {
      document.write('<tr><td align=center><img src="' + item[i].image + '"'
                   + ' width="' + Math.round(item[i].width / scaledown) + '"'
                   + ' height="' + Math.round(item[i].height / scaledown) + '">'
                   + '<br>' + item[i].colour + '</td>');
      }
    else
      {
      document.write('<tr><td align=center>' + item[i].colour + '</td>');
      }
    for ( j = 0 ; j < item[i].sizes.length; j++ ) 
      {
      if ( item[i].sizes[j] != '' )
        {
        document.write('<td>' + item[i].sizes[j] + '</td>');
        }
      else
        {
        document.write('<td>&nbsp;</td>');
        }
      }
    document.write('</tr>');
    }
  document.write('</table>');
}


function SetSelect(ref){
// initalise the two select statements
  var item = eval('x' + ref);
  var thiscolsel = document.getElementById('c' + ref);
  var thissizesel = document.getElementById('s' + ref);
  var nextopt = 0;
  for ( var i = 0; i < item.length; i++ )
    {
    thiscolsel.options[i] = new Option(item[i].colour, i+1);
    if ( i == 0 )
      {
      for ( j = 0 ; j < item[i].sizes.length; j++ )
        {
        if ( item[i].sizes[j] != '' ) thissizesel.options[nextopt++] = new Option(item[i].sizes[j], j+1); 
        }
      }
    }
//  thiscolsel.options[0].selected = true;
//  thissizesel.options[0].selected = true;
}

function setvalidsizes(indx, ref){
// when a different colour is selected, reset the vaid sizes
  var item = eval('x' + ref);
  var thissizesel = document.getElementById('s' + ref);
  thissizesel.options.length = 0;
  var nextopt = 0;
  for ( j = 0 ; j < item[indx].sizes.length; j++ )
    {
    if ( item[indx].sizes[j] != '' ) thissizesel.options[nextopt++] = new Option(item[indx].sizes[j], j+1); 
    }
}

function colourselect(ref){
// create the Colour Select tag
  document.write('<select id="c' + ref + '" name="v_' + ref + '_1"' 
               + ' onchange="setvalidsizes(this.selectedIndex, \'' + ref + '\')"></select>');
}

function sizeselect(ref){
// create the Colour Select tag
  document.write('<select id="s' + ref + '" name="v_' + ref + '_2"></select>');
}
// END Norcat Select Code