#---------------------------------------------------------------
#
# OCCPROTXScriptTemplate.pl	- code part of OCC script
#
# Copyright (c) Actinic Software Ltd 2001 All rights reserved
#
# *** Do not change this code unless you know what you are doing ***
#
# Written by George Menyhert
# Adapted for PROTX VPS Version 2.2 by Mat Peck - 27/05/2002
# Includes simple XOR encryption and Base64 encode functions
#
# This script is called by an eval() function and it will already
# have the following variables set up:
#
#	Expects:		$::sOrderNumber		- the alphanumeric order number for this order
#				$::nOrderTotal		- the total for this order (stored in based currency format e.g. 1000 = $10.00)
#				%::PriceFormatBlob   	- the price format data
#				%::InvoiceContact	- the customer invoice contact information
#				%::OCCShipData		- the customer delivery contact information
#				$::sCallBackURLAuth	- the URL of the authorization callback script
#				$::sCallBackURLBack	- the URL of the backup script
#				$::sCallBackURLUser	- the URL of the receipt script
#				$::sPath					- the path to the Catalog directory
#				$::sWebSiteUrl			- the Catalog web site URL
#				$::sContentUrl			- the content URL
#
#	Affects:		$::eStatus     		- the status of the transaction:
#				$::FAILURE 	- Failure
#				$::ACCEPTED - Accepted
#				$::REJECTED - Rejected
#				$::PENDING  - Pending
#				$::sErrorMessage		- error message if any
#				$::sHTML					- the HTML to display
#
#  $Revision: 4 $
#
#---------------------------------------------------------------

use strict;

$::eStatus = $::PENDING;								# The OCC plug-in runs in pending mode.  This script does not
											# perform the transaction.  Rather, it forwards the customer to
											# the OCC site for completion.
my (%VarTable);

######################################################################
# PROTX VPS Specific constants here
######################################################################

my $sPassword = 'testvendor';
my $sConfirmationEMail = 'test@test.com';

######################################################################

my $sPROTXURL = '';

if ($bTestMode) {
#  $sPROTXURL = "http://localhost/";
   $sPROTXURL = "https://ukvpstest.protx.com/";
} else {
#  $sPROTXURL = "http://localhost/";
   $sPROTXURL = "https://ukvps.protx.com/";
}

######################################################################


## Shared Script, different HTML templates;

$VarTable{$::VARPREFIX . 'OCC_URL'} =				# insert the OCC web site URL into the HTML template
	$sProcessScriptURL;

#
# only the Vendor name, Protocol ID and Transaction type are plain text for VPS
# all other values are passed in the encrypted CRYPT field
# First add the plain text values
#

my $sHiddenValues;
my $sCrypt;

$sHiddenValues .= "<INPUT TYPE=HIDDEN NAME=\"VPSProtocol\" VALUE=\"2.22\">\n";
$sHiddenValues .= "<INPUT TYPE=HIDDEN NAME=\"TxType\" VALUE=\"PAYMENT\">\n";
$sHiddenValues .= "<INPUT TYPE=HIDDEN NAME=\"Vendor\" VALUE=\"$sMerchantID\">\n";

#
# build up a string of all other values to encrypt and place in the crypt field
#

#
# VendorTxCode needs a random element to ensure this code has not been used before
#
$sCrypt .= "VendorTxCode=". $::sOrderNumber . "-" . int(rand(100000)) . "&";

#
# VPS requires decimal places in the amount (not lowest digits, so work them out).
#

my $nNumDigits = $::PriceFormatBlob{"ICURRDIGITS"};	# read the currency format values
my ($nAmount, $nFactor, $sAmount);
if(defined $nNumDigits)	{$nFactor = (10 ** $nNumDigits);} else {$nFactor = 100;}
$sAmount = sprintf("%d.%02d", $::nOrderTotal / $nFactor, $::nOrderTotal % $nFactor);

$sCrypt .= "Amount=". $sAmount . "&";
$sCrypt .= "Currency=". $::PriceFormatBlob{SINTLSYMBOLS} . "&";
$sCrypt .= "Description=Items from ". $sMerchantID . "&";

#
# URLs:
#		Strip them out and URL encode them for inclusion in the completion URL.
#		AUTH - the URL to create the authorization blob
#		BACK - the URL to return to the Catalog checkout process
#		USER - the URL to the receipt script
#

$sCrypt .= "SuccessURL=".$sPROTXURL."vps2Form/ActSuccess.asp?ActVendor=" .$sMerchantID. "&ActAmount=" . $::nOrderTotal . "&AuthURL=" . Base64Encode($::sCallBackURLAuth);
$sCrypt .= "&InvoiceURL=" . Base64Encode($::sCallBackURLUser) . "&";
$sCrypt .= "FailureURL=".$sPROTXURL."vps2Form/ActFail.asp?ActVendor=" .$sMerchantID. "&RedirectURL=" . Base64Encode($::sCallBackURLBack) . "&";


#
# add the invoice address and customer name
#
$sCrypt .= "CustomerName=" . $::InvoiceContact{NAME} . "&";
$sCrypt .= "BillingAddress=" . $::InvoiceContact{NAME} . "\n";
if (length($::InvoiceContact{JOBTITLE})!=0)  { $sCrypt .= $::InvoiceContact{JOBTITLE} . "\n"; }
if (length($::InvoiceContact{COMPANY})!=0)  { $sCrypt .= $::InvoiceContact{COMPANY} . "\n"; }
if (length($::InvoiceContact{ADDRESS1})!=0)  { $sCrypt .= $::InvoiceContact{ADDRESS1} . "\n"; }
if (length($::InvoiceContact{ADDRESS2})!=0)  { $sCrypt .= $::InvoiceContact{ADDRESS2} . "\n"; }
if (length($::InvoiceContact{ADDRESS3})!=0)  { $sCrypt .= $::InvoiceContact{ADDRESS3} . "\n"; }
if (length($::InvoiceContact{ADDRESS4})!=0)  { $sCrypt .= $::InvoiceContact{ADDRESS4} . "\n"; }
if (length($::InvoiceContact{COUNTRY})!=0)  { $sCrypt .= $::InvoiceContact{COUNTRY} . "\n"; }

#
# add the invoice post code 
#

$sCrypt .= "&BillingPostCode=" . substr($::InvoiceContact{POSTALCODE}, 0, 10);

if (length($::InvoiceContact{PHONE})!=0)  { $sCrypt .= "&ContactNumber=" . $::InvoiceContact{PHONE}; }
if (length($::InvoiceContact{FAX})!=0)  { $sCrypt .= "&ContactFax="  . $::InvoiceContact{FAX}; }


#
# add the delivery address 
#
$sCrypt .= "&DeliveryAddress=" . $::OCCShipData{NAME} . "\n";
if (length($::OCCShipData{JOBTITLE})!=0)  { $sCrypt .= $::OCCShipData{JOBTITLE} . "\n"; }
if (length($::OCCShipData{COMPANY})!=0)  { $sCrypt .= $::OCCShipData{COMPANY} . "\n"; }
if (length($::OCCShipData{ADDRESS1})!=0)  { $sCrypt .= $::OCCShipData{ADDRESS1} . "\n"; }
if (length($::OCCShipData{ADDRESS2})!=0)  { $sCrypt .= $::OCCShipData{ADDRESS2} . "\n"; }
if (length($::OCCShipData{ADDRESS3})!=0)  { $sCrypt .= $::OCCShipData{ADDRESS3} . "\n"; }
if (length($::OCCShipData{ADDRESS4})!=0)  { $sCrypt .= $::OCCShipData{ADDRESS4} . "\n"; }
if (length($::OCCShipData{COUNTRY})!=0)  { $sCrypt .= $::OCCShipData{COUNTRY} . "\n"; }
if (length($::OCCShipData{PHONE})!=0)  { $sCrypt .= "Tel: " . $::OCCShipData{PHONE} . "\n"; }
if (length($::OCCShipData{FAX})!=0)  { $sCrypt .= "Fax: " . $::OCCShipData{FAX} . "\n"; }

if (length($::OCCShipData{POSTALCODE})!=0)  { $sCrypt .= "&DeliveryPostCode=" . substr($::OCCShipData{POSTALCODE}, 0, 10); }

#
# Add confirmation email addresses if present.
#

if (length($::InvoiceContact{EMAIL})!=0)  { $sCrypt .= "&CustomerEMail=" . $::InvoiceContact{EMAIL}; }
if (length($sConfirmationEMail)!=0)  { $sCrypt .= "&VendorEMail=" . $sConfirmationEMail; }

# Add new 2.22 fields as well

$sCrypt .= "&eMailMessage=You can put your own message in here";
$sCrypt .= "&AllowGiftAid=0";
$sCrypt .= "&ApplyAVSCV2=0";
$sCrypt .= "&Apply3DSecure=0";

#
# add the crypt field to the POST 
#

$sCrypt = Base64Encode(SimpleXOR($sCrypt,$sPassword));
$sHiddenValues .= "<INPUT TYPE=HIDDEN NAME=\"Crypt\" VALUE=\"$sCrypt\">\n";


#
# Original OCC Script routines continue...
#


$VarTable{$::VARPREFIX . 'OCC_VALUES'} =			# add the OCC values to the template
	$sHiddenValues;

my $sLinkHTML = 'occlink.html';
if(defined $::g_pPaymentList)
	{
	$sLinkHTML = $$::g_pPaymentList{ActinicOrder::PaymentStringToEnum($::g_PaymentInfo{'METHOD'})}{BOUNCE_HTML};
	}
@Response = ACTINIC::TemplateFile($::sPath . $sLinkHTML, \%VarTable); # build the file

if ($Response[0] != $::SUCCESS)
	{
	$::eStatus = $::FAILURE;							# return a plug-in error
	$::sErrorMessage = $Response[1];
	return ($::SUCCESS);									# always return success if the script runs
	}

@Response = ACTINIC::MakeLinksAbsolute($Response[2], $::sWebSiteUrl, $::sContentUrl);
if ($Response[0] != $::SUCCESS)
	{
	$::eStatus = $::FAILURE;							# return a plug-in error
	$::sErrorMessage = $Response[1];
	return ($::SUCCESS);									# always return success if the script runs
	}

$::sHTML = $Response[2];								# grab the resulting HTML
#
# process the test mode warning
#
my ($sDelimiter) = $::DELPREFIX . 'TESTMODE';
if ($bTestMode)											# only include the test mode block if we are in test mode
	{
	$::sHTML =~ s/$sDelimiter//g;						# remove the delimiter text
	}
else															# not in test mode - remove the block
	{
	$::sHTML =~ s/$sDelimiter(.*?)$sDelimiter//gs;	# remove the test mode warning blob (/s removes the \n limitation of .)
	}

return ($::SUCCESS);

#
# End of Original OCCPROTXScriptTemplate.pl
#


# 
# Base64 encoding
# 
sub Base64Encode ($;$)
{
    my $res = "";
    my $eol = $_[1];
    $eol = "\n" unless defined $eol;
    pos($_[0]) = 0;                          # ensure start at the beginning

    $res = join '', map( pack('u',$_)=~ /^.(\S*)/, ($_[0]=~/(.{1,45})/gs));

    $res =~ tr|` -_|AA-Za-z0-9+/|;               # `# help emacs
    # fix padding at the end
    my $padding = (3 - length($_[0]) % 3) % 3;
    $res =~ s/.{$padding}$/'=' x $padding/e if $padding;
    return $res;
}


# 
# Base64 decoding
# 
sub Base64Decode ($)
{
    local($^W) = 0; 

    my $str = shift;
    $str =~ tr|A-Za-z0-9+=/||cd;            # remove non-base64 chars
    if (length($str) % 4) {
	require Carp;
	Carp::carp("Length of base64 data not a multiple of 4")
    }
    $str =~ s/=+$//;                        # remove padding
    $str =~ tr|A-Za-z0-9+/| -_|;            # convert to uuencoded format

    return join'', map( unpack("u", chr(32 + length($_)*3/4) . $_),
	                $str =~ /(.{1,60})/gs);
}


# 
# SimpleXor password encryption
# 
sub SimpleXOR ($;$)
{
  my $plain = $_[0];
  my $password = $_[1];
  my $passstring = $_[1];
  my $res = "";

  while (length($passstring) <= length($plain)) { $passstring .= $password; }
  $passstring = substr($passstring,0,length($plain));

  $res = $plain ^ $passstring;

  return $res;

}


