<?php

/***************************************************************
 *
 * actinic_main.php - Main inclusion file.
 *
 * This file is included all the time when a PHP expression
 * is evaluated on the desktop. All the code defined here will
 * be accessible by the PHP scripts inserted into the markup
 *
 **************************************************************
 * NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE NOTE
 *
 * Be careful editing this file as any errors here may mess up
 * the rendering. Always check the sytax of this file by
 * executing it from the command line!
 *
 **************************************************************
 *
 * @package main
 * @author Zoltan Magyar
 * @copyright Actinic Software Ltd 2005
 *
 * $Revision: 9 $
 *
 ***************************************************************/



/***************************************************************
 *
 * imagewidth - determinates the width of the passed in image
 *  The function is a wrapper for the gd library
 *
 * @param string $sFileName
 * @author Zoltan Magyar
 *
 ***************************************************************/

function imagewidth($sFileName)
	{
	list($width, $height, $type, $attr) = getimagesize($sFileName);
	echo $width;
	}

/***************************************************************
 *
 * imageheight - determinates the height of the passed in image
 *  The function is a wrapper for the gd library
 *
 * @param string $sFileName
 * @author Zoltan Magyar
 *
 ***************************************************************/

function imageheight($sFileName)
	{
	list($width, $height, $type, $attr) = getimagesize($sFileName);
	echo $height;
	}

/***************************************************************
 *
 * formattedcurrency - formats a number as currency
 *
 * @param float $fNumber
 * @param int $nDecimals
 * @param string $sDecimalSep
 * @param string $sThousandsSep
 * @param string $sCurrencySymbol
 * @author Oliver Hornyak
 *
 ***************************************************************/

function formattedcurrency($fNumber, $nDecimals, $sDecimalSep, $sThousandsSep, $sCurrencySymbol)
	{
	echo $sCurrencySymbol . number_format($fNumber, $nDecimals, $sDecimalSep, $sThousandsSep);
	}

/***************************************************************
 *
 * priceformat - wrapper function to format prices
 *
 * @param string $sFormat
 * @param string $sPrice
 * @param string $sPriceAlt
 * @author Oliver Hornyak
 *
 ***************************************************************/

function priceformat($sFormat, $sPrice, $sPriceAlt)
	{
	printf($sFormat, $sPrice, $sPriceAlt);
	}

/***************************************************************
 *
 * drawRows - Recursive function for drawing header cells of a row
 *
 * @param int $nAttributeIdx index of the current attribute
 * @param int $listCellChoiceIndices list of choice indices
 * @param string $sRowHeader row header
 * @author Zoltan Magyar
 *
 ***************************************************************/

function drawRows($nAttributeIdx, &$listCellChoiceIndices, $sRowHeader)
	{
	global $nYAttributeCount;
	global $nXAttributeCount;
	global $nBaseAttributeIdx;
	global $listHeaderDesigns;
	//
	// Till the last X attribute we compose row header,
	// when we reach the last one, we output table row header and move on to cell drawing
	//
	if ($nAttributeIdx <= $nXAttributeCount)	// we haven't put together the row header yet
		{
		//
		// Determine number of choices of current attribute
		//
		$nAttributeChoiceCount = count($listHeaderDesigns[$nBaseAttributeIdx + $nYAttributeCount + $nAttributeIdx - 1]) - 1;
		//
		// Loop through choices and compose row header cell for the choice name
		//
		for ($nChoiceIdx = 1; $nChoiceIdx <= $nAttributeChoiceCount; $nChoiceIdx++)
			{
			//
			// Remember which choice we are processing - we need to know it for table data cells
			//
			$listCellChoiceIndices[$nYAttributeCount + $nAttributeIdx] = $nChoiceIdx;
			//
			// Determine how many rows are occupied by this choice
			//
			$nRowSpan = 1;
			for ($i = $nAttributeIdx + 1; $i <= $nXAttributeCount; $i++)
				{
				$nRowSpan *= count($listHeaderDesigns[$nBaseAttributeIdx + $nYAttributeCount + $i - 1]) - 1;
				}
			//
			// Ignore start of row for 2nd, 3rd, etc. choices because of rowspans
			//
			if ($nChoiceIdx > 1)
				{
				$sRowHeader = "";
				}
			$sRowHeader .= "<li>";
			$sRowHeader .= $listHeaderDesigns[$nBaseAttributeIdx + $nYAttributeCount + $nAttributeIdx - 1][$nChoiceIdx];
			//
			// Do recursion on next attribute
			//
			drawRows($nAttributeIdx + 1, $listCellChoiceIndices, $sRowHeader);
			}
		}
	else					// we reached the last attribute, it's time to output row header and render row data cells
		{
		//
		// Draw table row header
		//
		echo $sRowHeader;

		//
		// Draw table data cells
		//
		$nColumnIdx = 1;
		drawRowCells($nColumnIdx, $listCellChoiceIndices);

		echo "";
		}
	}

/***************************************************************
 *
 * drawRowCells - Recursive function for drawing row data cells
 *
 * @param int $nColumnIdx index of the current column
 * @param int $listCellChoiceIndices list of choice indices
 * @author Zoltan Magyar
 *
 ***************************************************************/

function drawRowCells($nColumnIdx, &$listCellChoiceIndices)
	{
	global $nYAttributeCount;
	global $nXAttributeCount;
	global $nBaseAttributeIdx;
	global $listAttributeWidgets;
	global $listChoiceIds;
	global $listHeaderDesigns;
	global $listPermutations;
	global $sATC;
	global $sProdRef;
	global $sInvalidPermutation;
	global $sOOS;
	global $IsProductInStock;
	//
	// Build up a choice-permutation in listCellChoices and after that draw the cell
	//
		$nIsProductInStock = 0;
	if ($nColumnIdx <= $nYAttributeCount)
		{
		$nAttributeChoiceCount = count($listHeaderDesigns[$nBaseAttributeIdx + $nColumnIdx - 1]) - 1;
		for ($i = 1; $i <= $nAttributeChoiceCount; $i++)
			{
			$listCellChoiceIndices[$nColumnIdx] = $i;
			drawRowCells($nColumnIdx + 1, $listCellChoiceIndices);
			}
		}
	else					// we know which choices are displayed by this cell, thus draw the cell
		{
		//
		// Check for validity of the given permutation, iterate on permutation list
		//
		$nValid = 0;
		$nPermutationSize = count( $listPermutations );
		$nPermutationFound = 0;
		for( $nPermIdx = 1; $nPermIdx <= $nPermutationSize; $nPermIdx++ )
			{
				$nIsProductInStock = $IsProductInStock [ $nPermIdx ];
			//
			// Iterate on actual choices for the button and try to
			// find out whether these are present in actual permutation
			//
			$nPermChoiceSize = count( $listPermutations[ $nPermIdx ][ 0 ] );
			$nChoicesFound = 1;
			for ($i = 1; $i <= $nXAttributeCount + $nYAttributeCount; $i++)
				{
				//
				// Get next button choice
				//
				$nChoiceID = $listChoiceIds[ $nBaseAttributeIdx + $i -1 ][ $listCellChoiceIndices[ $i ] ][ 1 ];
				//
				// Check permutation's choices against it
				//
				$nChoiceFound = 0;
				for( $nPermChoiceIdx = 1; $nPermChoiceIdx <= $nPermChoiceSize; $nPermChoiceIdx++ )
					{
					if ( $listPermutations[ $nPermIdx ][ 0 ][ $nPermChoiceIdx - 1 ] == $nChoiceID )
						{
						$nChoiceFound = 1;
						break;
						}
					}

				//
				// If a button choice not found, we don't need this permutation
				//
				if ( $nChoiceFound == 0 )
					{
					$nChoicesFound = 0;
					break;
					}
				}
			//
			// If all the choices found, check the validity of the actual permutation
			//
			if ( $nChoicesFound == 1 )
				{
				$nPermutationFound = 1;
				$nValid = $listPermutations[ $nPermIdx ][ 1 ];
				break;
				}
			}

		//
		// If invalid permutation was found, skip this button
		// (if there's no permutation for this button, it should be displayed
		// by default)
		//
		if ( ( $nValid == 0 ) &&
			( $nPermutationFound == 1 ) )
			{
			echo <<<FREE_MARKUP_CODE_BLOCK
			$sInvalidPermutation
FREE_MARKUP_CODE_BLOCK;
			echo "</li>";
			}
		elseif
			( $nIsProductInStock <= 0 )
			{
			echo <<<FREE_MARKUP_CODE_BLOCK
			$sOOS
FREE_MARKUP_CODE_BLOCK;
			echo "</li>";
			}
		else
		{
			//
			// Draw table data cell
			//
			echo <<<FREE_MARKUP_CODE_BLOCK
			$sATC
FREE_MARKUP_CODE_BLOCK;
			echo "</li>";
			//+
			// Put together a unique ID for this cell that we can refer to
			// It has a form _choiceidx1_choiceidx2_...
			//
			$nUniqueCellId = '';
			for ($ChoiceIdx = 1; $ChoiceIdx <= count($listCellChoiceIndices); $ChoiceIdx++)
				{
				$nUniqueCellId .= '_' . $listCellChoiceIndices[$ChoiceIdx];
				}
			//
			// Insert a local JavaScript into the cell that will adjust hidden fields to reflect the selected cell
			//
			echo "<script type='text/javascript'>";
			echo "function onclick${nUniqueCellId}()";
			echo "{";
			for ($i = 1; $i <= $nXAttributeCount + $nYAttributeCount; $i++)
				{
				echo "var x=document.getElementsByName('{$listAttributeWidgets[$nBaseAttributeIdx + $i - 1]}');x[x.length - 1].value='{$listChoiceIds[$nBaseAttributeIdx + $i -1][$listCellChoiceIndices[$i]][0]}';";
				}
			echo "}";
			//
			// Redirect onclick of Add To Cart button to our script
			//
			echo "var x=document.getElementsByName('_$sProdRef');";	// Lookup ATC button by name
			echo "x[x.length - 1].onclick = onclick${nUniqueCellId};";	// Pick the latest ATC button
			echo "</script>";
			}
		}
	}

?>
