var depth = 3;
var headings = new Array(
	'title 1',
	'title 2',
	'title 3',
	'title 4',
	'title 5'
);
var elementId = 'dropdowns';
var before = '';
var after  = '<br />';
var sectionsToExclude = new Array();
var acatalog = 'acatalog';

var lastCaller = 1;

$(function() {
	if($('#' + elementId).length > 0) {
		var contents = $('#dropdowns').html();
		$('#dropdowns').html('');
		for(var i = 1; i <= depth; i++) {
			id = 'dropdowns-' + i;
			$('#' + elementId).append(before + '<select id="' + id + '"></select>' + after);
			$('#' + id).attr('disabled', 'disabled').change(onSelect);
			addDefault(id);
		}
		$('#dropdowns').append(contents);
		
		// Set the details of the top level sections
		createOptions(sections.sections, $('#dropdowns-1'), 1);
		$('#dropdowns-1').removeAttr('disabled');
		$('#dropdowns-1 option:first').attr('selected', 'selected');
	}
	
	function createOptions(sections, element, level) {
		var values = new Array();
		var names  = new Array();
		// Clear any options out of the select
		clearSelect(element.attr('id'));
		// Add in all the data from the JSON
		for(var i = 0; i < sections.length; i++) {
			// Check that this section is not being excluded
			if(!sectionsToExclude.contains(sections[i].id.substring('_'.length))) {
				var name = sections[i].name;
				// If there are children of the selected section
				// and the next dropdown won't be the last, set the value to an id
				if(sections[i].hasChildren && lastCaller < depth - 1) {
					values[name] = sections[i].id;
				} else {
					// Otherwise this option is a redirect so use the url
					values[name] = sections[i].url;
				}
				names[names.length] = name;
			}
		}
		// Sort the list
		names.sort();
		// Add the options in
		for(var i = 0; i < names.length; i++) {
			element.append('<option value="' + values[names[i]] + '">' + names[i] + '</option>');
		}
		addDefault(element.attr('id'));
		// Make sure the default is selected
		element.val('0');
	}
	
	function onSelect() {
		// Update the last called to the element which threw the event
		lastCaller = getDepth(this.id);
		// Clear all selects after this one
		clearSelects();
		// Get the value of the selected option
		value = $('#' + this.id + ' option:selected').val();
		// If it's 0, a heading has been selected so return
		if(value == 0) {
			//$('#' + this.id).attr('selected', 'selected');
			return;
		}
		// If it's an id, get its children; otherwise, redirect
		if(value.substring(0, 1) == '_') {
			// Grab the JSON associated with the option
			$.get(
				'/' + acatalog + '/' + value.substring(1, value.length) + '.js',
				'',
				fragmentReceived
			);
		} else {
			redirect(value);
		}
	}
	
	function fragmentReceived(data, textStatus) {
		// Read the JSON which will replace sections with the new data
		eval(data);
		// Get the ID of the next dropdown
		id = 'dropdowns-' + (1 + lastCaller * 1);
		// Add the JSON into the select
		createOptions(sections.sections, $('#' + id), lastCaller);
		// Enable the dropdown
		$('#' + id).removeAttr('disabled');
	}
	
	// Given the ID of a dropdown, return its level as a single number
	function getDepth(id) {
		return $('#' + id).attr('id').substring('dropdowns-'.length);
	}
	
	// Removes all the options from currently unused selects based on the level
	function clearSelects() {
		var startNode = (lastCaller * 1 + 1);
		for(var i = startNode; i <= depth; i++) {
			id = 'dropdowns-' + i;
			clearSelect(id);
			addDefault(id);
		}
	}
	
	// Clear all the contents of a select and disable it
	function clearSelect(id) {
		$('#' + id).html('').attr('disabled', 'disabled');
	}
	
	// Add in the default option for a select
	function addDefault(id) {
		$('#' + id).prepend('<option value="0" selected="selected">' + headings[(getDepth(id) * 1 - 1)] + '</option>');
	}
	
	function redirect(value) {
		window.location = '/' + acatalog +'/' + value;
	}
});

// Used to check if an object is in an array
Array.prototype.contains = function(needle) {
	for(var i = 0; i < this.length; i++) {
		if(this[i] === needle) return true;
	}
	return false;
}