<?php

error_reporting( E_ALL );

include( "json.php" );
$json = new Services_JSON(SERVICES_JSON_LOOSE_TYPE);

$file = str_replace( "\n", " ", file_get_contents("../acatalog/ActinicShipping.fil") );

preg_match( "/ClassTable = \(([^)]+)\)/i", $file, $match );
$match[1] = "{" . str_replace( "=>", ":", $match[1] ) ."}";
$names = $json->decode( $match[1] );


preg_match( "/ShippingTable = \(([^)]+)\)/i", $file, $match );
$match[1] = "{" . str_replace( "=>", ":", $match[1] ) ."}";
$prices = $json->decode( $match[1] );

$output = array();

foreach( $names as $id=>$arr )
{
	$row = new stdClass;

	$row->id = $id;
	$row->name = $arr[0];

	$price_row = array_pop( $prices[ $id ] );

	if( isset( $price_row[0]["FreeClass"] ) )
	{
		$row->price = 0;
		$row->price_text = "Free!";
	}
	else
	{
		$row->price = $price_row[1]['cost'] / 100;
		$row->price_text = "&pound;" . number_format( $row->price, 2, ".", "," );
	}

	array_unshift( $output, $row );
}