<?php
// dpimagesupport.php V1.06
// 08-08-14 V1.06	Supports creating transparent background PNG images.
// 21-05-14 V1.05	Warn if images to be opened are over 4000px wide or tall.
// 31-03-11 V1.04	New routine to create thumbnails from filename
// 12-03-09 V1.03	Different md5 test in Saveimage.  
//			Renamed variable within fitandscaleimage for readability.
// 23-02-07 V1.02	Added function saveimageforced - write image without checking if it exists.
// 23-02-07 V1.01	Amended fitandscaleimage to prevent scaling up.
// (c) 2007-2011 Drillpine Ltd - www.drillpine.biz
// NB close and restart Actinic after altering this code

function saveimage($image, $filename, $iconquality){	// save image unless it's already there (legacy code - no longer used)
	$errmessage = '';
	$writeimage = true;
	if ( file_exists($filename) )
		{
		if ( ! imagejpeg($image, 'mtempimage.jpg', $iconquality) )
			{
			$errmessage .= "Error saving mtempimage.jpg ! ";
			}
		else
			{
			$filemd5 = md5_file($filename);
			$imagemd5 = md5_file('mtempimage.jpg');
			if ( $imagemd5 == $filemd5 ) $writeimage = false;
			}		
		}

	if ( $writeimage ) 
		{
		if ( ! @imagejpeg($image, $filename, $iconquality) ) 
			{
			$errmessage .= "Error saving $filename ! ";
			}
		}

	return $errmessage;		
}  // end saveimage

function saveimageforced($image, $filename, $iconquality){	// save image without checking if it's already there
	$errmessage = '';
	$iconquality = round($iconquality);
	if ( ($iconquality < 0) || ($iconquality > 100) ) $iconquality = 100;
	if ( preg_match('/\.png$/', $filename ) )
		{
		$iconquality = round((100 - $iconquality) / 10);					// rescale 0 -> 100 (JPG) into 9 -> 0 (PNG)
		if ( $iconquality > 9 ) $iconquality = 9;
		if ( ! @imagepng($image, $filename, $iconquality) ) 					// transparent PNG
			{
			$errmessage .= "Error saving $filename! ";
			}
		}
	else
		{
		if ( ! @imagejpeg($image, $filename, $iconquality) ) 					// JPEG
			{
			$errmessage .= "Error saving $filename! ";
			}
		}	
	return $errmessage;		
}  // end saveimageforced

function fitandscaleimage($inputimage, $outputimagewidth, $outputimageheight, $bkgndr, $bkgndg, $bkgndb){	// fit image into specified size
	$inputimagewidth = imagesx($inputimage);
	$inputimageheight = imagesy($inputimage);
	$iconaspectratio = $inputimageheight / $inputimagewidth;
	$displayaspectratio = $outputimageheight / $outputimagewidth;
	if ( ($inputimagewidth <= $outputimagewidth) && ($inputimageheight <= $outputimageheight) ) 	// image is smaller so don't scale up
		{
		$outputwidth = $inputimagewidth;
		$outputheight = $inputimageheight;
		}
		
	else if ($iconaspectratio >= $displayaspectratio)						// must scale to height
		{
		$outputheight = $outputimageheight;
		$scale = $outputheight / $inputimageheight;
		$outputwidth = round($inputimagewidth * $scale);
		}

	else  												// scale to width
		{
		$outputwidth = $outputimagewidth;
		$scale = $outputwidth / $inputimagewidth;
		$outputheight = round($inputimageheight * $scale);
		}

	$xoffset = round(($outputimagewidth - $outputwidth) / 2);
	$yoffset = round(($outputimageheight - $outputheight) / 2);
	if ( ($bkgndr . $bkgndg . $bkgndb) == 'tra' )							// transparent PNG
		{
		// make output image sized transparent PNG background image
		$outputimage = ImageCreateTrueColor($outputimagewidth, $outputimageheight);
		//saving all full alpha channel information
		imagesavealpha($outputimage, true);
		//setting completely transparent color
		$transparent = imagecolorallocatealpha($outputimage, 0, 0, 0, 127);
		//filling created image with transparent color
		imagefill($outputimage, 0, 0, $transparent);
		}
	else
		{
		// make output image sized JPEG background image
		$outputimage = ImageCreateTrueColor($outputimagewidth, $outputimageheight);
		$bkgndcolor = imagecolorallocate($outputimage, $bkgndr, $bkgndg, $bkgndb);
		ImageFill($outputimage, 0, 0, $bkgndcolor);
		}
	// copy in existing image
	ImageCopyResampled($outputimage, $inputimage, $xoffset, $yoffset, 0, 0, 
			  $outputwidth, $outputheight, $inputimagewidth, $inputimageheight);
	return $outputimage;
}  // end fitandscaleimage

function makegreyscale($image){		// make and return grey scale version of image 
	$width = imagesx($image);
	$height = imagesy($image);
	$greyscaleimage = imagecreatetruecolor($width, $height);	// save the coloured one
	imagecopy($greyscaleimage, $image, 0, 0, 0, 0, $width, $height);
	for ($x = 0; $x < $width; $x++)
		{
		for ($y = 0; $y < $height; $y++)
			{
			$rgb = ImageColorAt($greyscaleimage, $x, $y); 	// get the rgb value for current pixel
			$rr = ($rgb >> 16) & 0xFF;			// extract each value for r, g, b
			$gg = ($rgb >> 8) & 0xFF;
			$bb = $rgb & 0xFF;
			$g = round(($rr + $gg + $bb) / 3);		// get the Value from the RGB value
			$val = imagecolorallocate($greyscaleimage, $g, $g, $g);// grayscale values have r=g=b=g
			imagesetpixel($greyscaleimage, $x, $y, $val);	// set the gray value
			}
		}
	return $greyscaleimage;
}  // end makegreyscale

function imageopen($ImageFileName){	// return image and info about it
	// returns $errmessage, $image, $imagewidth, $imageheight, $imagetype
	$dpmaximagesize = 4000;	// maximum image size allowed (width or height)
	$errmessage = '';
	list($imagewidth, $imageheight, $imagetype, $imageattr) = getimagesize($ImageFileName);
	if ( $imagewidth > $dpmaximagesize ) $errmessage = "<br>Image too wide ($imagewidth px)"; 
	if ( $imageheight > $dpmaximagesize ) $errmessage .= "<br>Image too tall ($imageheight px)"; 
	if ( $errmessage != '' )
		{
		return array("<br>$errmessage<br>Reduce to maximum dimension of $dpmaximagesize px",
			     false, $imagewidth, $imageheight, $imagetype);
		}
	switch ($imagetype) 
		{
		case 1:
			$image = @imagecreatefromgif($ImageFileName); /* Attempt to open */
			break;
		case 2:
			$image = @imagecreatefromjpeg($ImageFileName); /* Attempt to open */
			break;
		case 3:
			$image = @imagecreatefrompng($ImageFileName); /* Attempt to open */
			break;
		default:
			$image = NULL;	
			$errmessage .= "Unknown type $ImageFileName! ";				
		}
	return array($errmessage, $image, $imagewidth, $imageheight, $imagetype);
}  // end imageopen

function backgroundcolour($image, $type, $backgroundstring){	// return background colour r,g,b from image or from it's override
	if ( strlen($backgroundstring) == 6 )
		{ 
		$bkgndr = hexdec(substr($backgroundstring, 0, 2));	// use defined values
		$bkgndg = hexdec(substr($backgroundstring, 2, 2));
		$bkgndb = hexdec(substr($backgroundstring, 4, 2));
		}
	else
		{
		$rgb = ImageColorAt($image, 0, 0);
		if ( $type != 1 )	// jpg or png
			{
			$bkgndr = ($rgb >> 16) & 0xFF;
			$bkgndg = ($rgb >> 8) & 0xFF;
			$bkgndb = $rgb & 0xFF;
			}
		else
			{			// gif
			$colors = imagecolorsforindex($image, $rgb);
			$bkgndr = $colors['red'];
			$bkgndg = $colors['green'];
			$bkgndb = $colors['blue'];
			}
		}
	return array($bkgndr, $bkgndg, $bkgndb);
} // end backgroundcolour

function dpcreatethumbfromfile($SourceFileName, $Prefix, $Width, $Height, $Background = 'ffffff', $Compression = 85, $ShowSourceFileName = false, $DestDir = 'AutoScaledImages', $HaveMD5 = ''){ 
	// Create a thumbnail image if it doesn't exist
	// required params $SourceFileName, $Prefix, $Width, $Height. E.g. '<actinic:variable name="ProductImageFileName" />', 'thmb', 50, 50 
	// returns error message / false, dir+name of created image, image resource (if just created), MD5 of source image
	$SourceFileName = str_replace ( '\\', '/', $SourceFileName);		// replace troublesome backslashes
	if ( ! $HaveMD5 ) $HaveMD5 = md5_file($SourceFileName);			// if no MD5 supplied - calculate it
	if ( strlen($Background) != 6 )	$Background = 'ffffff';			// set valid background colour
	$ThumbImageName = ($DestDir ? $DestDir . '/' : '')
		. $Prefix . '_' 
		. ($ShowSourceFileName ? basename($SourceFileName) . '_' : '')
		. $HaveMD5 
		. '_' . $Width 
		. '_' . $Height 
		. '_' . $Background 
		. '_' . $Compression 
		. '.jpg';
	$ThumbImage = null;
	if ( ! file_exists($ThumbImageName) )
		{
		list($error, $SourceImage) = imageopen($SourceFileName);		// Attempt to open 
		if ( ! $SourceImage ) return array("Error in 'dpcreatethumbfrom' loading $SourceFileName $error", false, false, false);
		// Resample
		$ThumbImage = fitandscaleimage($SourceImage, $Width, $Height, hexdec(substr($Background, 0, 2)), hexdec(substr($Background, 2, 2)), hexdec(substr($Background, 4, 2)));
		// save the created icon
		$error = saveimageforced($ThumbImage, $ThumbImageName, $Compression);
		if ( $error ) return array("Error in 'dpcreatethumbfrom' saving $SourceFileName $error", false, false, false);
		}
	return array(false, $ThumbImageName, $ThumbImage, $HaveMD5);
} // end dpcreatethumbfromfile

?>	