
'==========================================================================
'
' NAME    : actinic_reformat.vbs
' DATE    : 12/12/2011
' Author  : Nilesh Parmar - www.alnavi.co.uk
' 
' COMMENT : Reads a CSV file & creates an Actinic Input File
'
'==========================================================================

Option Explicit

'-----------Build SortKey function---------

Private Function f_Build_SortKey(lev1, lev2, lev3, lev4, lev5)
	
	Dim nKeyLen
	nKeyLen = 3	
	f_Build_SortKey = String(nKeyLen - Len(CStr(lev1) ),"0") & CStr(lev1) 
	f_Build_SortKey = f_Build_SortKey & String(nKeyLen - Len(CStr(lev2) ),"0") & CStr(lev2) 
	f_Build_SortKey = f_Build_SortKey & String(nKeyLen - Len(CStr(lev3) ),"0") & CStr(lev3) 
	f_Build_SortKey = f_Build_SortKey & String(nKeyLen - Len(CStr(lev4) ),"0") & CStr(lev4) 
	f_Build_SortKey = f_Build_SortKey & String(nKeyLen - Len(CStr(lev5) ),"0") & CStr(lev5) & Chr(126)
	
End Function
'
'-----------End of Build SortKey function---------

'-----------sort function---------
'
Function ArraySort(ArrY)
	ReDim TempArray(255)
	
	Dim Word, UcaseWord, SmallList, temparraynum, biglist,smallarray
	
	For Each Word In ArrY
		UCaseWord = UCase(Word) & "   "
		TempArrayNum = Asc(Left(UCaseWord,1))
		TempArray(TempArrayNum) = TempArray(TempArrayNum) & vbCrLf  & Word
	Next
	
	For Each SmallList In TempArray
		If SmallList <>"" Then
			SmallArray = Split( Mid(SmallList,2 ),vbCrLf)
			'--------use not-so-fast method for each small array-------
			InsertionSort SmallArray
			'------------------------
			BigList = BigList & Join(SmallArray,vbCrLf)
		End If
	Next
	ArrY = Split(BigList,vbCrLf)
	Erase SmallArray
	Erase TempArray
End Function
'---------------------------------

'---------- old sort function---------
Function InsertionSort(arrX)
	Dim nUB : nUB = UBound(arrX)
	Dim i, j, v
	For i=1 To nUB
		v=arrX(i)
		j=i
		Do While arrX(j-1) > v
			arrX(j) = arrX(j-1)
			j=j-1
			If j<=0 Then
				Exit Do
			End If
		Loop
		arrX(j) = v
	Next
End Function
'---------------------------------

'----------- Product SubRoutine---------
Sub Build_Product( sSub_Name, sSub_Desc )	
	
	Dim sHideOnWeb
	Dim sStockCheckedEnable
	
	If sMasterProduct Then 
		sHideonWeb = "0"
		sStockCheckedEnable = "0"
	Else    
		sHideonWeb = "1"
		sStockCheckedEnable = "1"
	End If 
	
	' -----  Write Out Product Record 
	' "Header:Product,Product Reference,Short Description,Full Description,Report Description,AlnaViSelectable,Hide on Web Site,BrandName,brand,BrandLogo,Price,Cost Price,RRP,Image Filename,Thumbnail,Barcode,ean,isbn,upc,Alna Vi Sale,Alna Vi Group,nContentCategory,ShoeSize,AlnaViSaleable,Alna Vi Season,Alna Vi Product Note,IsComingSoon,IsProductNew,ShoeLining,ShoeUpper,ShoeSole,ShoeFitting,ShoeStyle,HeelSize,ManufacturersStyle,Colour,Can be Ordered Online,Stock Checks Enabled,Stock in Hand,Clicking Product Image in Product List,Use Product Page,Product Page Name,Use Product Page in Site Map"							
	sOutString = sSortKey & "Product," & sQuote & sSub_Name & sQuote & "," & sQuote & sSub_Desc & sQuote 
	
	' Removed Full & Report Description - 15Dec2011
	'	sOutString = sOutString &  "," & sQuote & sSub_Desc & sQuote & "," & sQuote & sSub_Desc & sQuote 
	
	sOutString = sOutString &  ","  & sHideonWeb & "," & sStockCheckedEnable & "," & sQuote & sPrice & sQuote & "," & sQuote & sCost & sQuote 
	
	' ------ Add The Custom variables to the Header Records 				
	For i=0 To (nCustvars -1 ) 
		
		If sMasterProduct Then 
			' For MASTER record, Use the Default Provided
			sOutString = sOutString  & "," & sCustVarDefault(i)
		Else
			' For MASTER record, Use the Default Provided
			sOutString = sOutString  & "," &  sCustVarProductValue(i) 
		End If
		
		
	Next
	
	sOutString = sOutString   & vbCrLf				
	If bDiag Then	
		Log_Message   " sOutString : " & sOutString	
	End If			
	oTemp1.write sOutString
	
End Sub
'------------------------------------

'-----------Component SubRoutine---------
Sub Build_Component ()
	' "Header:Component,Component Name,Price,Quantity,Name HTML,Is Optional,Selected by default,Associated Product Reference,Uses Associated Product Prices,Uses Associated Product Name,Uses Associated Product Tax,Component As Separate Order Line,Include No Choice Label,No Choice Label Text,IsDeleted,Content Category,Use Associated Product Shipping,Include Grid of Choice Details,Include Prices,Hide Out of Stock Options,AttributeList,ComponentLayout,PermutationLayout,PermutationPrice,ComponentAttributeList"		
	' Component,"Selection",0,1,"",0,0,"",0,0,0,0,0,"None",0,"Standard",0,0,0,1,"","","Permutation Drop Down List","","" 
	
	sOutString = sSortKey & "Component," & sQuote & "Selection" & sQuote & ",0,1," & sDoubleQuote & ",0,0," 
	sOutString = sOutString & sDoubleQuote & ",0,0,0,0,0," & sQuote & "None" & sQuote & ",0,"
	sOutString = sOutString & sQuote & "Standard" & sQuote & ",0,0,0,1,"
	sOutString = sOutString & sDoubleQuote  & "," & sDoubleQuote & "," & sQuote & "Permutation Drop Down List" & sQuote & ","
	sOutString = sOutString & sDoubleQuote & "," & sDoubleQuote  & "," & sDoubleQuote  
	sOutString = sOutString   & vbCrLf
	If bDiag Then	
		Log_Message   " sOutString : " & sOutString	
		
	End If
	oTemp1.write sOutString
	
End Sub
'------------------------------------

'-----------Attribute SubRoutine---------
Sub Build_Attribute ( sAtt_Name, sAtt_HTMLName )
	
	' "Header:Attribute,Attribute Name,Name HTML,Type,IsDeleted,Content Category,AttributeLayout,PermutationLayout,RadioButtonColumnCount"
	' Attribute,"Size","Size",0,0,"Standard","","Permutation Drop Down List","" 
	
	sOutString = sSortKey & "Attribute," & sQuote & sAtt_Name & sQuote & "," & sQuote & sAtt_Name  & sQuote & ",0,0," & sQuote & "Standard" & sQuote & "," & sDoubleQuote 
	sOutString = sOutString & "," & sQuote & "Permutation Drop Down List" & sQuote& "," & sQuote & sUseParent & sQuote 
	sOutString = sOutString   & vbCrLf
	If bDiag Then	
		Log_Message   " sOutString : " & sOutString	
	End If
	oTemp1.write sOutString
	
End Sub
'------------------------------------

'-----------Choice SubRoutine---------
Sub Build_Choice ( sAtt_Name , sAtt_HTMLName)
	
	' "Header:Choice,Choice Name,Name HTML,IsDeleted,Content Category"
	' Choice, "10","10",0,"Standard"
	
	sOutString = sSortKey & "Choice," & sQuote & sAtt_Name & sQuote & "," & sQuote  & sAtt_HTMLName  &  sQuote & ",0," & sQuote & "Standard" & sQuote 
	sOutString = sOutString   & vbCrLf
	If bDiag Then	
		Log_Message   " sOutString : " & sOutString	
	End If
	oTemp1.write sOutString	
	
End Sub
'------------------------------------

'-----------Choice SubRoutine---------
Sub Build_Permutation ()
	
	' "Header:Permutation,Permutation String,Price,Is Valid,Associated Product Reference,Pricing,Uses Associated Product Name,Uses Associated Product Tax,Use Associated Product Shipping,Barcode,PermutationPrice"
	'  Permutation,"Size:10;Colour:001 Black",0,1,"FF-016001-100",2,0,0,0,"","" 		
	sOutString = sSortKey & "Permutation," & sQuote & sHDR_Att_2 & ":" & sAtt_2 & ";" & sHDR_Att_1 & ":" & sAtt_1 & sQuote & ",0,0,1," 
	sOutString = sOutString & sQuote & sProductRef & sQuote & ",2,0,0,0," & sDoubleQuote  & "," & sQuote & sUseParent &sQuote 
	sOutString = sOutString   & vbCrLf
	If bDiag Then	
		Log_Message   " sOutString : " & sOutString	
	End If
	oTemp1.write sOutString
	
End Sub
'------------------------------------

'-----------Choice SubRoutine---------
Sub Log_Message ( sLogMessage)
	
	If bDiag Then									
		
		'		WScript.Echo sLogMessage
		
	End If
	
	sLogMessage = sLogMessage & vbCrLf
	oLogFile.write sLogMessage	
	sLogMessage = ""
	
End Sub
'------------------------------------

'-----------File Sort Routine SubRoutine---------
Sub File_Sort_Routine ()
	'
	' -------Sort The Output Here --------
	'
	Dim ObjOutputFile
	Set FSO = CreateObject("Scripting.FileSystemObject")
	Set ts = fso.GetFile(sTemp1).OpenAsTextStream(1)
	
	myArray = Split(ts.ReadAll, vbCrLf)
	ts.Close
	
	'-------------test sort-------
	ArraySort MyArray' time2 = Timer
	'------------write result------
	
	Set objOutputFile = fso.CreateTextFile(sTemp2, True)
	objOutputFile.WriteLine Join(MyArray, vbCrLf)
	ObjOutputFile.Close
	'
	'-------end of Sort ------
	'
	
End Sub
'------------------------------------

'
' -------Remove Sort Key from every record --------
'
Sub Remove_SortKey ()
	
	Dim ObjOutputFile, sPrevious_Rec, sLineNo
	Set fso = CreateObject("Scripting.FileSystemObject")
	Set ts = fso.GetFile(sTemp2).OpenAsTextStream(1)
	
	Set objOutputFile = fso.CreateTextFile(sOutFile, True)
	
	sLineNo = 1	
	Do While Not ts.AtEndOfStream
		sText = ts.ReadLine
		
		' Check if its Blank Line
		If sText <> "" Then 
			
			' Check if its duplicate of Previous Rec
			If sPrevious_Rec <> sText Then 
				' Its NOT duplicate Line - Process it 
				
				If Trim(sText) <> "" Then
					records = Split(stext, Chr(126) )
					ObjOutputFile.WriteLine records(1)
				End If		
			Else
				' Duplicate Record
				Log_Message " Line " & sLineNo & " Duplicate Record : " & sText
				
			End If 
		Else
			' Blank Line 
			Log_Message   " Line " & sLineNo & " Blank  Record : " & sText
			
		End If
		
		'Set the Current line as the Previous Rec
		sPrevious_Rec = sText
		sLineNo = sLineNo + 1
	Loop
	
	ObjOutputFile.Close
	ts.Close
	'
	'-------end of Remove Sort Key Routine
	'
End Sub
'------------------------------------


' ------ Set Diagnostic Switch

Dim bDiag
bDiag = False


' -------- Prompt For Diag Switch - Currently commented Out 
' Dim sDiagSwitch
' sDiagSwitch=MsgBox("Switch on Diagnostics? " ,vbYesNo, "Diagnostic Switch")

' If sDiagSwitch = vbYes Then
'	MsgBox "Diagnostic Switch on - Output to Logfile"
'	bDiag = True
' Else
' 	MsgBox "No Diagnostics Needed"
' 	bDiag = False
' End If
'------------------------------------


' ------ Define & Set Variables
Dim MyList, myArray, ts, i, j, x, temp, line, report
Dim FSO, sCurrentPath
Dim oFSO, sFile, oFile, sOutfile, oOutFile, sLogFile, oLogFile, sText,records , ForReading, ForWriting
Dim sTemp1, sTemp2, oTemp1, oTemp2,  sQuote , sDoubleQuote, sQuote5, stilde , sSpace, strText, strNewText
Dim nProductHeaders, nFixedHeaders
Dim sCustVarName(100) , sCustVarDefault(100)  , sCustVarProductValue(100)
Dim sCustVarString, sCustVars
Dim sHContent, sHProduct, sHComponent, sHAttribute, sHChoice, sHPermutation 
Dim sComponent_Default
Dim sLineNo, sNewLine , sParsedLine
Dim sOutString, sLogOut
Dim sStyle, sDescription, sSubstyle, sSubStyleDesc, sAtt_1, sAtt_2 , sProductRef , sProductDesc, sPrice , sCost, sQuantity , sDefaults 
Dim sCurr_Style, sCurr_SubStyle
Dim sHDR_Att_1 , sHDR_Att_2 , sHTML_Att_1, sHTML_Att_2 
Dim sUseParent, sMasterProduct

Dim nLevel_1, nLevel_2, nLevel_3, nLevel_4 , nLevel_5, nKeyLen,nCustvars
Dim sSortKey

sCurrentPath = CreateObject("Scripting.FileSystemObject").GetAbsolutePathName(".")

WScript.Echo "Starting Procedure : " & WScript.ScriptName & " from " & sCurrentPath

' ------ Initialise Variables
nLevel_1 = 0
nLevel_2 = 0
nLevel_3 = 0
nLevel_4 = 0
nLevel_5 = 0
nCustvars = 0
sUseParent = "__UseParent__"
sMasterProduct = False
sSortKey = f_build_sortKey( nLevel_1, nLevel_2, nLevel_3, nLevel_4, nLevel_4) 

sNewLine = Chr(13)
stilde = Chr(126)
sQuote = Chr(34)
sSpace = Chr(32) 

sDoubleQuote = sQuote & sQuote
sQuote5 = sQuote & sQuote & sQuote & sQuote & sQuote

nFixedHeaders = 13

Dim ObjFSO, InitFSO

Set ObjFSO = CreateObject("UserAccounts.CommonDialog")

ObjFSO.Filter = "VBScripts|*.vbs|Text Documents|*.txt|All Files|*.*"
ObjFSO.FilterIndex = 3
ObjFSO.InitialDir = sCurrentPath

InitFSO = ObjFSO.ShowOpen
If InitFSO = False Then
	WScript.Echo "Script Error: Please select a file!"	
	WScript.Quit
Else	
	WScript.Echo "Input File Selected : " & ObjFSO.FileName	
End If

sFile = ObjFSO.FileName

Set oFSO = CreateObject("Scripting.FileSystemObject")
ForReading = 1
ForWriting = 2

'sFile = InputBox(" Input File - Full path please!", "Name of File To Process")
'sOutFile = InputBox("Output File - Full path please!", "Output File in Actinic Format")

'uncomment the next line if you want to have a static file location
'sFile  = "Z:\Documents\Actinic v11\Scripting\testdata\product_template3.csv"
sOutfile  = sCurrentpath & "\Output_file.csv"


' ------ Create Temp Files
sTemp1 = sCurrentpath & "\temp1.csv"
sTemp2 = sCurrentpath & "\temp2.csv"

sLogFile = sCurrentpath & "\log.txt"

'comment out the next line if you want to supress prompting for the file location
'sortFile = InputBox("What file should I sort?  Full path please!", "File To Sort")
'uncomment the next line if you want to have a static file location

' ------ Open Output File for writing 
Set oTemp1 = oFSO.CreateTextFile (stemp1, ForWriting)
Set oTemp2 = oFSO.CreateTextFile (stemp2, ForWriting)
Set oLogFile = oFSO.CreateTextFile (sLogFile, ForWriting)


sCurr_Style = ""
sCurr_SubStyle = ""

' ------ Define & Set Hierarchic File Headers
sHContent = sSortKey & "Header:ContentCategories,Name,Content Level,Sequence,Default"
sHProduct = sSortKey & "Header:Product,Product Reference,Short Description,Hide on Web Site,Stock Checks Enabled,Price,Cost"
sHComponent   = sSortKey & "Header:Component,Component Name,Price,Quantity,Name HTML,Is Optional,Selected by default,Associated Product Reference,Uses Associated Product Prices,Uses Associated Product Name,Uses Associated Product Tax,Component As Separate Order Line,Include No Choice Label,No Choice Label Text,IsDeleted,Content Category,Use Associated Product Shipping,Include Grid of Choice Details,Include Prices,Hide Out of Stock Options,AttributeList,ComponentLayout,PermutationLayout,PermutationPrice,ComponentAttributeList"
sHAttribute   = sSortKey & "Header:Attribute,Attribute Name,Name HTML,Type,IsDeleted,Content Category,AttributeLayout,PermutationLayout,RadioButtonColumnCount"
sHChoice      = sSortKey & "Header:Choice,Choice Name,Name HTML,IsDeleted,Content Category"
sHPermutation = sSortKey & "Header:Permutation,Permutation String,Price,IsDeleted,Is Valid,Associated Product Reference,Pricing,Uses Associated Product Name,Uses Associated Product Tax,Use Associated Product Shipping,Barcode,PermutationPrice"

sComponent_Default = "Component," & sQuote & "Selection" & sQuote & ",0,1,"
'
'  ------------- Unused Header Params
' ,BrandName,brand,BrandLogo,Price,Cost Price,RRP,Image Filename,Thumbnail,Barcode,ean,isbn,upc,Alna Vi Sale,Alna Vi Group,nContentCategory,ShoeSize,AlnaViSaleable,Alna Vi Season,Alna Vi Product Note,IsComingSoon,IsProductNew,ShoeLining,ShoeUpper,ShoeSole,ShoeFitting,ShoeStyle,HeelSize,ManufacturersStyle,Colour,Can be Ordered Online,Stock Checks Enabled,Stock in Hand,Clicking Product Image in Product List,Use Product Page,Product Page Name,Use Product Page in Site Map"
'
'
' ------ Main Code 
'

Log_Message   "  Input File  : " & sFile  
Log_Message   "  Log File    : " & sLogFile  
Log_Message   "  TempFile 1  : " & sTemp1  
Log_Message   "  TempFile 2  : " & sTemp2  
Log_Message   "  OutPutFile  : " & sOutfile  

sOutString = "  Following Files are Created / Used : " & sNewLine & sNewLine
sOutString = sOutString &  "  Input File  : " & sFile     & sNewLine 
sOutString = sOutString &  "  Log File    : " & sLogFile  & sNewLine
sOutString = sOutString &  "  TempFile 1  : " & sTemp1    & sNewLine
sOutString = sOutString &  "  TempFile 2  : " & sTemp2    & sNewLine
sOutString = sOutString &  "  OutPutFile  : " & sOutfile  & sNewLine

WScript.Echo sOutString

If oFSO.FileExists(sFile) Then
	
	'	Set oFile = oFSO.OpenTextFile(sFile, ForReading)
	
	Set oFile = oFSO.GetFile(sFile).OpenAsTextStream(1, -2)	
	
	sLineNo = 1
	Do While Not oFile.AtEndOfStream
		sText = oFile.ReadLine
		If Trim(sText) <> "" Then
			Log_Message   "  Processing Line : " & sLineNo & " - " & sText  
		End If	
		
		records=Split(sText, ",")
		
		nProductHeaders = UBound(records) + 1	
		nCustvars = nProductHeaders - (nFixedHeaders) 
		
		sStyle         = records(0)
		sDescription   = records(1)
		sSubstyle      = records(2)
		sSubStyleDesc  = records(3)
		sAtt_1         = records(4)
		sAtt_2         = records(5)
		sHTML_Att_1    = records(6)
		sHTML_Att_2    = records(7)
		sProductRef    = records(8)	
		sProductDesc   = records(9)
		sPrice         = records(10)
		sCost          = records(11)
		sQuantity      = records(12)
		
		' Get All Custom Variables
		For i=0 To (nCustvars - 1)			       
			sCustVarProductValue(i) = records(nFixedHeaders + i)
		Next		
		
		If bDiag Then									
			
			Log_Message  " Current Style      : " & sCurr_Style
			Log_Message   " Current Style      : " & sCurr_Style
			Log_Message   " Current Substyle      : " & sCurr_SubStyle			
			Log_Message   " Style         : " & sStyle
			Log_Message   " Description   : " & sDescription
			Log_Message   " Substyle      : " & sSubstyle		
			Log_Message   " SubStyle Desc : " & sSubStyleDesc
			Log_Message   " " & sHDR_Att_1 & " : " & sAtt_1
			Log_Message   " " & sHDR_Att_2 & " : " & sAtt_2
			Log_Message   " ProductRef    : " & sProductRef
			Log_Message   " Product Desc  : " & sProductDesc
			Log_Message   " Price         : " & sPrice
			Log_Message   " Cost          : " & sCost
			Log_Message   " Quantity      : " & sQuantity
			
			For i=0 To (nCustvars - 1)			       
				Log_Message   " Custom Variable " & sCustVarName(i) & " : " &  sCustVarProductValue(i) 
			Next
			Log_Message   " " 			
		End If
		
		' -----  Now We've read the record in from CSV file - See if its the first Record 
		' ------ For First Rec, Read & set Attribute Names
		' 
		If 	sLineNo = 1 Then
			' ----- For First Rec, Read & set Attribute Names
			sCurr_Style = records(0)
			sCurr_SubStyle = records(2)			
			sHDR_Att_1 = sAtt_1 
			sHDR_Att_2 = sAtt_2 			
			
			Log_Message   "  There are  " & nProductHeaders  & " Product Headers and " & nFixedHeaders & " Fixed Headers with " & nCustvars & " Cust Variables"  
			Log_Message   "  "
			
			For i=0 To (nCustvars -1 ) 
				
				sCustVarString = records(nFixedHeaders + i)
				
				sCustVars = Split( sCustVarString, "=")
				sCustVarName(i) = sCustVars(0)
				sCustVarDefault(i) = sCustVars(1)  
				
				'Resolve the Actinic Variable Name
				If InStr(sCustVarName(i),sQuote) > 0 Then
					Log_Message " Input String is >> " & sCustVarName(i) & "<< "
					sCustVarName(i) = Replace(sCustVarName(i), sQuote, "")
					Log_Message " Output String is >> " & sCustVarName(i) & "<< "
				End If
				
				
				Log_Message " Input String is >> " & sCustVarDefault(i)& "<< "
				
				'Resolve the Actinic Variable Name
				If InStr(sCustVarDefault(i),sQuote5) > 0 Then
					' Default Value is Null
					sCustVarDefault(i) = sDoublequote
				Else 
					' Default Value Has Value - Remove Quotes
					While (InStr( sCustVarDefault(i), sDoubleQuote) > 0 )
						sCustVarDefault(i) = Replace(sCustVarDefault(i), sDoubleQuote, sQuote)
					Wend
				End If
				Log_Message " Output String is >> " & sCustVarDefault(i) & "<< "

				Log_Message " "
				Log_Message   " Name of Cust Variable " & (i) & " >>"& sCustVarName(i)  & "<< & Default Value is >>" &  sCustVarDefault(i) & "<<" 				
				
				' ------ Add The Custom variables to the Header Records 
				sHProduct = sHProduct & "," & sCustVarName(i) 
				
			Next
			If bDiag Then	
				Log_Message   "       : "  
				Log_Message   " H1 : " & sHContent
				Log_Message   " H2 : " & sHProduct
				Log_Message   " H3 : " & sHComponent
				Log_Message   " H4 : " & sHAttribute
				Log_Message   " H5 : " & sHChoice
				Log_Message   " H6 : " & sHPermutation
				Log_Message   "       : " 				            
			End If
			
			' ------ Write out Hierarchic File Headers
			oTemp1.Write sHContent & vbCrLf
			oTemp1.Write sHProduct & vbCrLf
			oTemp1.Write sHComponent & vbCrLf
			oTemp1.Write sHAttribute & vbCrLf
			oTemp1.Write sHChoice & vbCrLf
			oTemp1.write sHPermutation & vbCrLf
			
		Else		
			'
			' -----  Its Not the First Record.- Now, Lets Check if its a new Style or Substyle
			'
			If sCurr_SubStyle <> sSubstyle Then 										
				'
				' ----- NEW SUBSTYLE - Now, Since Its a new Substyle, Check if the Style Has Changed 
				If sCurr_Style <> sStyle Then				
					' -------NEW STYLE & NEW SUBSTYLE
					' -----  This is a Totally New style, so we need to build the Master Product bits
					' ------ Increament Level 1 & Reset all other Levels back to 0 			
					sCurr_Style = sStyle 
					nLevel_1 = nLevel_1 + 1
					nLevel_2 = 0
					nLevel_3 = 0
					nLevel_4 = 0
					nLevel_5 = 0
					' ----- Build The Master (Style ) Product			
					sMasterProduct = True
					sSortKey = f_build_sortKey( nLevel_1, nLevel_2, nLevel_3, nLevel_4, 9) 
					Build_Product sStyle, sDescription				
					
					' -----  Build the Component Line for the Master Product  							
					sSortKey = f_Build_SortKey( nLevel_1, nLevel_2, 1,0,0) 		
					Build_Component 
					
					' -----  Build the Size Attribute Line for the Master Product  
					sSortKey = f_build_sortKey( nLevel_1, nLevel_2, 2,0,0) 		
					Build_Attribute "Size" 	, sHTML_Att_2
					
					' -----  Build the Colour Attribute Line for the Master Product  
					sSortKey = f_build_sortKey( nLevel_1, nLevel_2, 3,0,0) 		
					Build_Attribute "Colour" , sHTML_Att_1 	
				Else
					' ------- NEW SUBSTYLE but NOT new STYLE
					' ------- Now, Substyle has changed but not the master Style 
					' ------- So Build the 
					sSortKey = f_build_sortKey( nLevel_1, 0, 2,3, 1) 					
					Build_Choice sAtt_2 ,sHTML_Att_2	
				End If
				' ------- Not A New Style OR SUBSTYLE
				' ------- So Build the 
				' -----  Set SubStyle variable 
				sCurr_SubStyle = sSubstyle 	
				' sSubStyleDesc = sStyle & " in " & sAtt_1
				
				' -----  New SubStyle, So Icrement Level 2 & redefine New SortKey  					
				sMasterProduct = True					
				nLevel_2 = nLevel_2 + 1								
				sSortKey = f_build_sortKey( nLevel_1, nLevel_2, nLevel_3,1, nLevel_5) 						
				Build_Product sSubstyle, sSubStyleDesc				
				
				' -----  Define New SortKey for the component element 									
				sSortKey = f_build_sortKey( nLevel_1, nLevel_2, nLevel_3,2, nLevel_5) 			
				Build_Component 				
				
				' Sortkey for Size Attribute is setting nlevel_4 = 3 				
				sSortKey = f_build_sortKey( nLevel_1, nLevel_2, 2,3, nLevel_5) 		
				Build_Attribute "Size"	,sHTML_Att_2		
				
				' Sortkey for Size Attribute is setting nlevel_4 = 3 				
				sSortKey = f_build_sortKey( nLevel_1, nLevel_2, 3,4, nLevel_5) 		
				Build_Attribute "Colour" ,	sHTML_Att_1		
				
				' Choices fall under Attributes, so Sortkey will have same nlevel_4 as Attribute (i.e.  3 for Size & 4 for Colour)
				' but nlevel_5 is set to 1  
				'				sSortKey = f_build_sortKey( nLevel_1, nlevel_2, nLevel_3, 3, 1) 		
				'				Build_Choice sAtt_2
				
				' Choices fall under Attributes, so Sortkey will have same nlevel_4 as Attribute (i.e.  3 for Size & 4 for Colour)
				' but nlevel_5 is set to 1  
				sSortKey = f_build_sortKey( nLevel_1, nlevel_2, 3, 4, 1) 		
				Build_Choice sAtt_1 ,sHTML_Att_1	
				
				'				sSortKey = f_build_sortKey( nLevel_1, 0, nLevel_3,3, 1) 		
				'				Build_Choice sAtt_2
				
				sSortKey = f_build_sortKey( nLevel_1, 0, 3,4, 1) 					
				Build_Choice sAtt_1 ,sHTML_Att_1	
			End If
			
			' ------- Build the Choice  nLevel_3 to 4 with , both nLevel_4 & 5 to 0
			' ------- and before (nlevel4=0) the master Style product is defined.
			
			sSortKey = f_build_sortKey( nLevel_1, nLevel_2, 2,3, 1) 					
			Build_Choice sAtt_2 ,sHTML_Att_2	
			
			
			' ------- Build the Permutation nLevel_3 to 4 with , both nLevel_4 & 5 to 0
			' ------- and before (nlevel4=0) the master Style product is defined.
			
			sSortKey = f_build_sortKey( nLevel_1, 0, 2,3, 1) 		
			Build_Choice sAtt_2 ,sHTML_Att_2	
			
			' ------- Build the Permutation nLevel_3 to 4 with , both nLevel_4 & 5 to 0
			' ------- and before (nlevel4=0) the master Style product is defined.
			sSortKey = f_build_sortKey( nLevel_1, nLevel_2, 4,0, 0) 		
			Build_Permutation 
			
			' ------- Build the Permutation nLevel_3 to 4 with, both nLevel_4 & 5 to 0
			' ------- As its for master product, Set SubStyle Code in Key (level_2) to 0 
			sSortKey = f_build_sortKey( nLevel_1, 0, 4, 0, 0) 		
			Build_Permutation 
			
			' ------- Set Sortkey so Hidden subproducts come at Style Level (nLeve_2=0)
			' ------- and before (nlevel4=0) the master Style product is defined.
			sMasterProduct = False									
			sSortKey = f_build_sortKey( nLevel_1, 0, 0,0, 6) 				
			Build_Product sProductRef , sProductDesc
			
		End If 				
		sLineNo = sLineNo + 1	
		
	Loop
	oFile.Close
	oTemp1.Close
	oTemp2.Close
	
	Log_Message   "Calling File Sort Routine"
	File_Sort_Routine 
	
	Log_Message   "Calling Remove Sort Key Routine"
	Remove_SortKey  
	
	
	Log_Message   "Closing Log File "
	oLogFile.Close
	
Else
	Log_Message   "Unable to Load nput file "
	
End	If

sOutString = "Procedure Completed : " & WScript.ScriptName & sNewLine & sNewLine   
sOutString = sOutString &  "  Check Output File & Logfile for any errors  "  & sNewLine 
sOutString = sOutString &  "  Log File    : " & sLogFile  & sNewLine
sOutString = sOutString &  "  OutPutFile  : " & sOutfile  & sNewLine

WScript.Echo sOutString

