################################################################
#                                                     			#
# Paypal Pro interface for Actinic EC cart scripts             #
#                                                     			#
# Copyright (c) 2007 SellerDeck Limited         				#
#                                                     			#
# written by Zoltan Magyar                          				#
#																					#
# $Revision$                                                    #
#                                                     			#
################################################################


$::PAYPAL_LIVE_SERVER = 'api-3t.paypal.com';
$::PAYPAL_TEST_SERVER = 'api-3t.sandbox.paypal.com';
$::PAYPAL_LIVE_EC_SERVER = 'https://www.paypal.com/cgi-bin/webscr?cmd=_express-checkout&token=%s';
$::PAYPAL_TEST_EC_SERVER = 'https://www.sandbox.paypal.com/cgi-bin/webscr?cmd=_express-checkout&token=%s';
$::PAYPAL_LIVE_EC_SERVER_IN_CONTEXT = 'https://www.paypal.com/checkoutnow?token=%s';
$::PAYPAL_TEST_EC_SERVER_IN_CONTEXT = 'https://www.sandbox.paypal.com/checkoutnow?token=%s';
$::PAYPAL_SERVER_PORT = 443;
$::PAYPAL_CONNECTION_TIMEOUT = 45;
$::PAYPAL_TESTMODE	= $bTestMode;
$::BNID_EC = 'ActinicCat_Cart_EC';
$::PAYPAL_API_VERSION   = '117.0';

$::PAYPAL_USER			= $sADF01;
$::PAYPAL_PWD			= $sADF02;
$::PAYPAL_SIGNATURE	= $sADF03;
$::PAYPAL_ENC_PARAM	= $sADFDump;
$::PAYPAL_IN_CONTEXT_CHECKOUT = $sADF04 eq "1" ? $::TRUE : $::FALSE;
$::s_sLastURL = undef;
$::PAYPAL_SOLUTION_TYPE = $sADF05 eq "0" ? "Sole" : "Mark";
$::PAYPAL_LANDING_PAGE = $sADF06 eq "0" ? "Login" : "Billing";
$::PAYPAL_BRAND_NAME = $sADF07;
$::PAYPAL_LOGO_IMAGE = $sADF08;
$::PAYPAL_HEADER_IMAGE = $sADF09;

#######################################################
#
# StartPaypalProCheckout - implements paypal pro start
# checkout call
#
# Returns:	0 - $::SUCCESS or $::FAILURE
#				1 - undef or error message
#
# Author: Zoltan Magyar
#
#######################################################

sub StartPaypalProCheckout
	{
	#
	# Validate the cart first
	#
	if ($::PAYPAL_IN_CONTEXT_CHECKOUT)
		{
		#
		# If in-context checkout make sure the cancel URL is already set here
		# in order to return to the correct page
		#
		$::s_sLastURL = $::Session->GetLastPage();
		}
	my @Response = ActinicOrder::ValidateStart($::TRUE); # validate the input/cart settings
	if ($Response[0] != $::SUCCESS)
		{
		return(@Response);
		}
	#
	# Make a start checkout call to Paypal
	#
	my $oPaypal = new ActinicPaypalConnection();
	my $nAmount = ActinicOrder::GetOrderTotal();
	if ($nAmount == 0)
		{
		@Response = ACTINIC::BounceToPageEnhanced(5, ACTINIC::GetPhrase(-1, 2449),
																$$::g_pSetupBlob{CHECKOUT_DESCRIPTION},
																$::g_sWebSiteUrl,
																$::g_sContentUrl, $::g_pSetupBlob, $::Session->GetLastPage(), \%::g_InputHash,
																$::FALSE);
		return($::BADDATA, $Response[2]);
		}
	my ($nStatus, $sMessage, $sToken, $sPayerID) = $oPaypal->DoStartCheckout($nAmount);
	if ($nStatus != $::SUCCESS)
		{
		@Response = ACTINIC::BounceToPageEnhanced(5, ACTINIC::GetPhrase(-1, 2450, $sMessage),
																$$::g_pSetupBlob{CHECKOUT_DESCRIPTION},
																$::g_sWebSiteUrl,
																$::g_sContentUrl, $::g_pSetupBlob, $::Session->GetLastPage(), \%::g_InputHash,
																$::FALSE);
		return($::BADDATA, $Response[2]);
		}
	$::Session->SetPaypalProIDs($sToken, $sPayerID);
	if (defined $::s_sLastURL)
		{
		$::s_sLastURL = undef;
		}
	#
	# Now redirect to paypal
	#
	my $sRedirectHTML = $oPaypal->GetRedirectHTML($sToken);

	return($::SUCCESS, $sRedirectHTML);
	}

################################################################
#
# CompleteCheckout - do all we need once control is back from Paypal
#
################################################################

sub CompletePaypalProCheckout
	{
	my $sToken = $::g_InputHash{"token"} ;
	my $oPaypal = new ActinicPaypalConnection();
	my $sError;
	
	$oPaypal->SetParam("METHOD", "GetExpressCheckoutDetails");
	$oPaypal->SetParam("TOKEN", $sToken);
	$oPaypal->SendRequest();

	my $hResponse = $oPaypal->GetResponseHash();

	if ($$hResponse{ACK} =~ /^failure/i)
		{
		return ($::FAILURE, $$hResponse{L_LONGMESSAGE0});
		}
		
	$::Session->SetPaypalProIDs($sToken, $$hResponse{"PAYERID"});
	undef %::g_ShipContact;
	undef %::g_BillContact;
	#
	# At present the invoice address is a copy of the deliver address
	#
	$::g_LocationInfo{SEPARATESHIP} = '';
	#
	# We have to translate GB to UK to be ISO compatible
	#
	$$hResponse{"PAYMENTREQUEST_0_SHIPTOCOUNTRYCODE"} =~ s/^GB$/UK/;
	#
	# Name handling
	#
	my ($sFirstName, $sLastName);
	$::g_ShipContact{'NAME'}		= $$hResponse{"PAYMENTREQUEST_0_SHIPTONAME"};
	$sLastName = $::g_ShipContact{'NAME'};			# default to a blank first name and complete last name
	if ($sLastName =~ /^(.+)\s+(\S+)/)				# if the name field looks to contain at least two name parts
		{
		$sFirstName = $1;									# break the name up
		$sLastName = $2;
		}
	$::g_ShipContact{'NAME'}		= substr($$hResponse{"PAYMENTREQUEST_0_SHIPTONAME"}, 0, $::g_pFieldSizes->{'NAME'});
	$::g_ShipContact{'FIRSTNAME'}		= substr($sFirstName, 0, $::g_pFieldSizes->{'FIRSTNAME'}); 
	$::g_ShipContact{'LASTNAME'}		= substr($sLastName, 0, $::g_pFieldSizes->{'LASTNAME'});	
	$::g_ShipContact{'JOBTITLE'}	= $$hResponse{""};
	$::g_ShipContact{'COMPANY'}	= substr($$hResponse{"BUSINESS"}, 0, $::g_pFieldSizes->{'COMPANY'});
	$::g_ShipContact{'ADDRESS1'}	= substr($$hResponse{"PAYMENTREQUEST_0_SHIPTOSTREET"}, 0, $::g_pFieldSizes->{'ADDRESS1'});
	$::g_ShipContact{'ADDRESS2'}	= substr($$hResponse{"PAYMENTREQUEST_0_SHIPTOSTREET2"}, 0, $::g_pFieldSizes->{'ADDRESS2'});
	$::g_ShipContact{'ADDRESS3'}	= substr($$hResponse{"PAYMENTREQUEST_0_SHIPTOCITY"}, 0, $::g_pFieldSizes->{'ADDRESS3'});
	$::g_ShipContact{'ADDRESS4'}	= substr($$hResponse{"PAYMENTREQUEST_0_SHIPTOSTATE"}, 0, $::g_pFieldSizes->{'ADDRESS4'});
	$::g_ShipContact{'POSTALCODE'}= substr($$hResponse{"PAYMENTREQUEST_0_SHIPTOZIP"}, 0, $::g_pFieldSizes->{'POSTALCODE'});
	#
	# If simple tax and simple shipping then we cannot translate the code to a country so just use the code
	#
	$::g_ShipContact{'COUNTRY'}	= (ACTINIC::GetCountryName($$hResponse{"PAYMENTREQUEST_0_SHIPTOCOUNTRYCODE"}) ne "") ?
												ACTINIC::GetCountryName($$hResponse{"PAYMENTREQUEST_0_SHIPTOCOUNTRYCODE"}) : $$hResponse{"PAYMENTREQUEST_0_SHIPTOCOUNTRYCODE"};
	$::g_ShipContact{'PHONE'}		= substr($$hResponse{"PAYMENTREQUEST_0_SHIPTOPHONENUM"}, 0, $::g_pFieldSizes->{'PHONE'});
	$::g_ShipContact{'MOBILE'}		= $$hResponse{""};	
	$::g_ShipContact{'FAX'}			= $$hResponse{""};
	$::g_ShipContact{'EMAIL'}		= substr($$hResponse{"EMAIL"}, 0, $::g_pFieldSizes->{'EMAIL'});
	$::g_ShipContact{'USERDEFINED'}= $$hResponse{""};
	$::g_LocationInfo{DELIVERY_COUNTRY_CODE} = $$hResponse{"PAYMENTREQUEST_0_SHIPTOCOUNTRYCODE"};
	$::g_LocationInfo{DELIVERY_REGION_CODE} = ActinicOrder::GetSellerDeckRegion($$hResponse{"PAYMENTREQUEST_0_SHIPTOCOUNTRYCODE"}, $::g_ShipContact{'ADDRESS4'}, $::g_ShipContact{'POSTALCODE'});

	if ($::g_LocationInfo{DELIVERY_REGION_CODE} eq $ActinicOrder::UNDEFINED_REGION)
		{
		#
		# Region is undefined, check if need it
		#
		if (ActinicOrder::StateRequiredForValidation('Delivery', $::g_LocationInfo{DELIVERY_COUNTRY_CODE}))
			{
			$sError = ACTINIC::GetPhrase(-1, 3066);
			}
		}
	else
		{
		#
		# We have a valid region code so lets get the region name
		#
		$::g_ShipContact{'ADDRESS4'} = $$::g_pLocationList{$::g_LocationInfo{DELIVERY_REGION_CODE}}{'NAME'};
		}

	$::g_BillContact{'NAME'}		= substr($$hResponse{"FIRSTNAME"} . " " . $$hResponse{"LASTNAME"}, 0, $::g_pFieldSizes->{'NAME'});
	$::g_BillContact{'FIRSTNAME'}		= substr($$hResponse{"FIRSTNAME"}, 0, $::g_pFieldSizes->{'FIRSTNAME'});
	$::g_BillContact{'LASTNAME'}		= substr($$hResponse{"LASTNAME"}, 0, $::g_pFieldSizes->{'LASTNAME'});
	$::g_BillContact{'JOBTITLE'}	= $$hResponse{""};
	$::g_BillContact{'COMPANY'}	= substr($$hResponse{"BUSINESS"}, 0, $::g_pFieldSizes->{'COMPANY'});
	$::g_BillContact{'ADDRESS1'}	= substr($$hResponse{"PAYMENTREQUEST_0_SHIPTOSTREET"}, 0, $::g_pFieldSizes->{'ADDRESS1'});
	$::g_BillContact{'ADDRESS2'}	= substr($$hResponse{"PAYMENTREQUEST_0_SHIPTOSTREET2"}, 0, $::g_pFieldSizes->{'ADDRESS2'});
	$::g_BillContact{'ADDRESS3'}	= substr($$hResponse{"PAYMENTREQUEST_0_SHIPTOCITY"}, 0, $::g_pFieldSizes->{'ADDRESS3'});
	$::g_BillContact{'ADDRESS4'}	= substr($$hResponse{"PAYMENTREQUEST_0_SHIPTOSTATE"}, 0, $::g_pFieldSizes->{'ADDRESS4'});
	$::g_BillContact{'POSTALCODE'}= substr($$hResponse{"PAYMENTREQUEST_0_SHIPTOZIP"}, 0, $::g_pFieldSizes->{'POSTALCODE'});
	$::g_BillContact{'COUNTRY'}	= $::g_ShipContact{'COUNTRY'};
	$::g_BillContact{'PHONE'}		= substr($$hResponse{"PHONENUM"}, 0, $::g_pFieldSizes->{'PHONE'});
	$::g_BillContact{'MOBILE'}		= $$hResponse{""};
	$::g_BillContact{'FAX'}			= $$hResponse{""};
	$::g_BillContact{'EMAIL'}		= substr($$hResponse{"EMAIL"}, 0, $::g_pFieldSizes->{'EMAIL'});
	$::g_BillContact{'USERDEFINED'}= $$hResponse{""};
	#
	# Invoice address is the same as the delivery address
	#
	$::g_LocationInfo{INVOICE_COUNTRY_CODE} = $::g_LocationInfo{DELIVERY_COUNTRY_CODE};
	$::g_LocationInfo{INVOICE_REGION_CODE} = $::g_LocationInfo{DELIVERY_REGION_CODE};
	if ($::g_LocationInfo{INVOICE_REGION_CODE} eq $ActinicOrder::UNDEFINED_REGION)
		{
		#
		# Region is undefined, check if need it
		#
		if (($sError eq '') &&
			 (ActinicOrder::StateRequiredForValidation('Invoice', $::g_LocationInfo{INVOICE_COUNTRY_CODE})))
			{
			$sError = ACTINIC::GetPhrase(-1, 3066);
			}
		}
	else
		{
		#
		# We have a valid region code so lets get the region name
		#
		$::g_BillContact{'ADDRESS4'} = $$::g_pLocationList{$::g_LocationInfo{INVOICE_REGION_CODE}}{'NAME'};
		}
	#
	# Get tax and shipping info updated
	#
	CheckShippingAndTax(\$sError);

	ActinicOrder::UpdateCheckoutRecord();

	return (DisplayOrderConfirmPhase($sError));
	}

#######################################################
#
# ValidateOrderConfirmPhase - validate the content of the
#	 confirm page
#
# Returns:	0 - error message if any error occured
#
#######################################################

sub ValidateOrderConfirmPhase
	{
	my $sError = ValidateGeneral($::TRUE);
	my @Response;
	#
	# Gather the T&C flag
	#
	$::g_BillContact{'AGREEDTANDC'}	= (defined $::g_InputHash{'AGREETERMSCONDITIONS'} && $::g_InputHash{'AGREETERMSCONDITIONS'} ne "") ? $::TRUE : $::FALSE;
	#
	# Check coupon code
	#
	if ($$::g_pDiscountBlob{'COUPON_ON_CHECKOUT'})	# if allowed at all during checkout
		{
		$::Session->GetCartObject();					# be sure discounting package is loaded
		if (ActinicDiscounts::IsMultipleFixedPriceCouponAccepted())
			{			
			if ($::g_InputHash{'COUPONCODE'} ne "")		# if we got coupon code
				{
				@Response = ActinicDiscounts::ValidateCoupon($::g_InputHash{'COUPONCODE'});
				if ($Response[0] == $::FAILURE)
					{
					$sError .= ACTINIC::GetPhrase(-1, 1971,  $::g_sRequiredColor) . $Response[1] . ACTINIC::GetPhrase(-1, 1970);
					}
				}
			elsif ($::Session->GetCSVCouponCodes() ne $::Session->GetCSVCouponCodesOrig())
				{				
				$sError .= ACTINIC::GetPhrase(-1, 1971,  $::g_sRequiredColor) . "Your order may have changed due to a change with the coupon code(s). Please recheck your order." . ACTINIC::GetPhrase(-1, 1970);
				$::Session->SetCSVCouponCodesOrig($::Session->GetCSVCouponCodes()); # save new entries
				}
			}
		elsif ($::g_InputHash{'COUPONCODE'} ne "")		# if we got coupon code			 
			{
			@Response = ActinicDiscounts::ValidateCoupon($::g_InputHash{'COUPONCODE'});
			if ($Response[0] == $::FAILURE)
				{
				$sError .= ACTINIC::GetPhrase(-1, 1971,  $::g_sRequiredColor) . $Response[1] . ACTINIC::GetPhrase(-1, 1970);
				}
			elsif ($::g_PaymentInfo{'COUPONCODE'} ne $::g_InputHash{'COUPONCODE'})
				{
				$sError .= ACTINIC::GetPhrase(-1, 1971,  $::g_sRequiredColor) . "Your order may have changed due to a change with the coupon code. Please recheck your order." . ACTINIC::GetPhrase(-1, 1970);
				}
			$::g_PaymentInfo{'COUPONCODE'} = $::g_InputHash{'COUPONCODE'};
			}
		}
	#
	# Check the T&C flag
	#
	if ($$::g_pSetupBlob{'CHECKOUT_NEEDS_TERMS_AGREED'} &&	# T&C flag is used
		 !$::g_BillContact{'AGREEDTANDC'})			# but it is not checked
		{
		$sError .= ACTINIC::GetPhrase(-1, 2385);	# get the appropriate message
		}
	#
	# User defined requires special validation
	#
	if (ACTINIC::IsPromptRequired(0, 14) &&
		$::g_BillContact{'USERDEFINED'} eq "" &&
		!$ACTINIC::B2B->Get('UserDigest'))
		{
		$sError .= ACTINIC::GetRequiredMessage(0, 14);
		}
	if (length $::g_BillContact{'USERDEFINED'} > $::g_pFieldSizes->{'USERDEFINED'})
		{
		$sError .= ACTINIC::GetLengthFailureMessage(0, 14, $::g_pFieldSizes->{'USERDEFINED'});
		}
	#
	# Before validating shipping and tax we need to see if we
	# have been given a change of invoice or delivery region
	#
	if ((defined $::g_InputHash{'LocationDeliveryRegion'}) &&
		 ($::g_InputHash{'LocationDeliveryRegion'} ne $ActinicOrder::UNDEFINED_REGION))
		{
		$::g_LocationInfo{DELIVERY_REGION_CODE} = $::g_InputHash{'LocationDeliveryRegion'};
		$::g_ShipContact{'ADDRESS4'} = $$::g_pLocationList{$::g_LocationInfo{DELIVERY_REGION_CODE}}{'NAME'};
		}

	if ($::g_LocationInfo{SEPARATESHIP} ne '')
		{
		if ((defined $::g_InputHash{'LocationInvoiceRegion'}) &&
			 ($::g_InputHash{'LocationInvoiceRegion'} ne $ActinicOrder::UNDEFINED_REGION))
			{
			$::g_LocationInfo{INVOICE_REGION_CODE} = $::g_InputHash{'LocationInvoiceRegion'};
			$::g_BillContact{'ADDRESS4'} = $$::g_pLocationList{$::g_LocationInfo{INVOICE_REGION_CODE}}{'NAME'};
			}
		}
	else
		{
		#
		# Use the new delivery region for the invoice region as we have 
		# Will be replaced if a different invoice region has been entered
		#
		$::g_LocationInfo{INVOICE_REGION_CODE} = $::g_LocationInfo{DELIVERY_REGION_CODE};
		$::g_BillContact{'ADDRESS4'} = $::g_ShipContact{'ADDRESS4'};
		}
	CheckShippingAndTax(\$sError);

	if ($sError eq '')
		{
		#
		# If there are no errors but the order total has changed
		# then the buyer must be allowed to check the changes
		#
		my (@Response) = $::Session->GetCartObject($::FALSE);
		if ($Response[0] != $::SUCCESS)				# general error
			{
			return (@Response[1]);						# return error
			}
		my $pCartObject = $Response[2];
		my $pCartList = $pCartObject->GetCartList();

		@Response = $pCartObject->SummarizeOrder($::FALSE);	# calculate the order total
		if ($Response[0] != $::SUCCESS)				# general error
			{
			return (@Response[1]);						# return error
			}
		if ($Response[6] != $::Session->GetPaypalOrderTotal())
			{
			$sError = ACTINIC::GetPhrase(-1, 1971,  $::g_sRequiredColor) . "Your order value has changed due to the changes you made. Please recheck your order." . ACTINIC::GetPhrase(-1, 1970);
			}
		}
	ActinicOrder::UpdateCheckoutRecord();
	return ($sError);
	}

#######################################################
#
# CheckShippingAndTax - check the shipping and tax
#
# Params:	0 - error message
#
# Returns:	apends to the passed error message
#
#######################################################

sub CheckShippingAndTax
	{
	my ($pError) = shift;
	my $sSep = ($$pError eq '') ? "" : '<br>';
	#
	# Validate shipping
	#
	my ($sShipError) = ValidateShipCharge($::TRUE);
	if ($sShipError ne '')
		{
		$$pError .= $sSep . $sShipError;
		$sSep = '<br>';
		}
	#
	# Validate tax
	#
	my ($sTaxError) = ActinicOrder::ValidateTax($::TRUE);
	if ($sTaxError ne '')
		{
		$$pError .= $sSep . $sTaxError;
		}
	}

#######################################################
#
# DisplayOrderConfirmPhase - display the ship charge
#	 page
#
# Params:	0 - error message if any
#
# Returns:	0 - status
#				1 - error if any
#
# Affects:	%::s_VariableTable, @::s_DeleteDelimiters,
#				@::s_KeepDelimiters
#
#######################################################

sub DisplayOrderConfirmPhase
	{
	my %hVariableTable;
	my @aDeleteDelimiters;
	my @aKeepDelimiters;

	my ($Message, $Status);
	my ($sError) = @_;
	#
	# Adjust the invoice state for the address if it is mandatory
	#
	my $bInvoiceUsesRegion = $::FALSE;
	my $bShipSeparately = ($::g_LocationInfo{SEPARATESHIP} ne '');
	if(defined $$::g_pLocationList{INVOICEADDRESS4} &&
					$$::g_pLocationList{INVOICEADDRESS4})
		{
		$bInvoiceUsesRegion = $::TRUE;
		$::g_BillContact{ADDRESS4} = ActinicLocations::GetInvoiceAddressRegionName($::g_BillContact{ADDRESS4});
		}
	#
	# Adjust the delivery state for the address if it is mandatory
	#
	if(defined $$::g_pLocationList{DELIVERADDRESS4} &&
					$$::g_pLocationList{DELIVERADDRESS4})
		{
		$::g_ShipContact{ADDRESS4} = ActinicLocations::GetDeliveryAddressRegionName($::g_ShipContact{ADDRESS4});
		#
		# Also adjust the state for the invoice address if
		# invoice doesn't use region and is not ship separately
		#
		if (!$bInvoiceUsesRegion &&					# invoice doesn't use region
			 !$bShipSeparately)							# not ship separately
			{
			$::g_BillContact{ADDRESS4} = ActinicLocations::GetInvoiceAddressRegionName($::g_BillContact{ADDRESS4});
			}
		}
	else
		{
		#
		# Also adjust the state for the delivery address if
		# invoice doesn't use region and is not ship separately
		#
		if ($bInvoiceUsesRegion &&						# invoice doesn't use region
			 !$bShipSeparately)							# not ship separately
			{
			$::g_ShipContact{ADDRESS4} = ActinicLocations::GetDeliveryAddressRegionName($::g_ShipContact{ADDRESS4});
			}
		}
	my $bKeepDelivery4Change = $::FALSE;
	my $bKeepInvoice4Change = $::FALSE;
	#
	# If we need a State for the delivery address then
	# if what we have is invalid we shall prompt for one
	#
	if ((ActinicOrder::StateRequiredForValidation('Delivery', $::g_LocationInfo{DELIVERY_COUNTRY_CODE})) &&
		 ($::g_LocationInfo{DELIVERY_REGION_CODE} eq $ActinicOrder::UNDEFINED_REGION))
		{
		$bKeepDelivery4Change = $::TRUE;
		}
	#
	# If we need a State for the invoice address then
	# if what we have is invalid we shall prompt for one
	# We shall prompt under the delivery address though if
	# we are using the shipping address as the invoice address
	#
	if ((ActinicOrder::StateRequiredForValidation('Invoice', $::g_LocationInfo{INVOICE_COUNTRY_CODE})) &&
		 ($::g_LocationInfo{INVOICE_REGION_CODE} eq $ActinicOrder::UNDEFINED_REGION))
		{
		if ($::g_LocationInfo{SEPARATESHIP} ne '')
			{
			$bKeepInvoice4Change = $::TRUE;
			}
		else
			{
			$bKeepDelivery4Change = $::TRUE;
			}
		}
	#
	# Do we need the Delivery address change?
	#
	if ($bKeepDelivery4Change)
		{
		push (@aKeepDelimiters, 'DELIVERYADDR4CHANGE');
		}
	else
		{
		push (@aDeleteDelimiters, 'DELIVERYADDR4CHANGE');
		}
	#
	# Do we need the Invoice address change?
	#
	if ($bKeepInvoice4Change)
		{
		push (@aKeepDelimiters, 'INVOICEADDR4CHANGE');
		}
	else
		{
		push (@aDeleteDelimiters, 'INVOICEADDR4CHANGE');
		}

	my ($sTemp, @Response);
	#
	# Add other prompts
	#
	$hVariableTable{$::VARPREFIX.'YOURRECEIPT'} 		= ACTINIC::GetPhrase(-1, 336);	# This is your receipt.
	$hVariableTable{$::VARPREFIX.'PRINTTHISPAGE'} 	= ACTINIC::GetPhrase(-1, 337);	# Print this page and keep it for your records.
	$hVariableTable{$::VARPREFIX.'NEEDTOCONTACT'} 	= ACTINIC::GetPhrase(-1, 338);	# If you need to contact us, refer to the
	$hVariableTable{$::VARPREFIX.'INVOICETO'} 		= ACTINIC::GetPhrase(-1, 339);	# Invoice To:
	$hVariableTable{$::VARPREFIX.'DELIVERTO'} 		= ACTINIC::GetPhrase(-1, 340);	# Deliver To:
	$hVariableTable{$::VARPREFIX.'DATETEXT'} 			= ACTINIC::GetPhrase(-1, 342);	# Date:
	#
	# Do the addresses
	# The invoice and delivery variables are dealt with by PXML processing of the
	# INVOICEADDRESSDETAILS and DELIVERYADDRESSDETAILS tags
	#
	$hVariableTable{$::VARPREFIX.'MOVING'} = $::g_BillContact{'MOVING'} ? ACTINIC::GetPhrase(-1, 1914) : ACTINIC::GetPhrase(-1, 1915);	# set the moving text
	#
	# Invoice first
	#
	my ($sInvoiceName);
	undef $sTemp;
	if ((length $::g_BillContact{'NAME'}) > 0)		# if the contact name exists
		{
		$sTemp = $::g_BillContact{'SALUTATION'} . " " . $::g_BillContact{'NAME'};
		@Response = ACTINIC::EncodeText($sTemp);
		$sInvoiceName .= $Response[1] . "<BR>\n";	# add it to the message display
		}
	$hVariableTable{$::VARPREFIX.'INVOICENAME'} = $sInvoiceName; # add the invoice address to the reciept
	#
	# Delivery next
	#
	my ($sDeliveryName);
	if ((length $::g_ShipContact{'NAME'}) > 0)		# if the contact name exists
		{
		$sTemp = $::g_ShipContact{'SALUTATION'} . " " . $::g_ShipContact{'NAME'};
		@Response = ACTINIC::EncodeText($sTemp);
		$sDeliveryName .= $Response[1] . "<BR>\n";	# add it to the message display
		}
	$hVariableTable{$::VARPREFIX.'DELIVERYNAME'} = $sDeliveryName; # add the invoice address to the reciept
	#
	# Calculate the order total since it is used in a couple of places
	#
	@Response = $::Session->GetCartObject($::FALSE);
	if ($Response[0] != $::SUCCESS)					# general error
		{
		return (@Response);								# error so return empty string
		}
	my $pCartObject = $Response[2];
	my $pCartList = $pCartObject->GetCartList();

	@Response = $pCartObject->SummarizeOrder($::FALSE);		# calculate the order total
	if ($Response[0] != $::SUCCESS)
		{
		return (@Response);
		}
	my ($Ignore0, $Ignore1, $nSubTotal, $nShipping, $nTax1, $nTax2, $nTotal, $nShippingTax1, $nShippingTax2,
		$nHandling, $nHandlingTax1, $nHandlingTax2) = @Response;

	#
	# hide the moving status if it was not asked
	#
	if (ACTINIC::IsPromptHidden(0, 13))				# no moving prompt
		{
		push (@aDeleteDelimiters, 'MOVINGSTATUS');
		}
	else
		{
		push (@aKeepDelimiters, 'MOVINGSTATUS');
		}
	#
	# Display deliver message if entered
	#
	if (!$::g_ShipInfo{'USERDEFINED'})				# no special instruction
		{
		push (@aDeleteDelimiters, 'DELIVERYINSTRUCTION');
		}
	else
		{
		$hVariableTable{$::VARPREFIX.'DELIVERYINSTRUCTION_LABEL'} = ACTINIC::GetPhrase(-1, 2044);
		$hVariableTable{$::VARPREFIX.'DELIVERYINSTRUCTION_TEXT'} = $::g_ShipInfo{'USERDEFINED'};
		push (@aKeepDelimiters, 'DELIVERYINSTRUCTION');
		}
	#
	# Shipping
	#
	my ($status, $sMessage, $pVarTable, $pDeleteDelimiters, $pKeepDelimiters) = ActinicOrder::DisplayShipChargePhase();
	if ($status != $::SUCCESS)						# on error - bail
		{
		#
		# since displaying the shipping charge phase failed, unselect the default
		# country since it may change.  It may have been erroneously entered.
		#
		my $sDeliveryCountry = ACTINIC::GetCountryName($::g_LocationInfo{DELIVERY_COUNTRY_CODE});
		if ($::g_BillContact{COUNTRY} eq $sDeliveryCountry && # if the bill contact country had been defaulted to the one selected in the preliminary phase
			 !$$::g_pLocationList{EXPECT_INVOICE})		 # and the invoice address is guessed to be in the same location as the delivery address
			{
			undef $::g_BillContact{COUNTRY};	# unselect it
			}
		if ($::g_ShipContact{COUNTRY} eq $sDeliveryCountry) # same for the destination country
			{
			undef $::g_ShipContact{COUNTRY};
			}
		}

	%hVariableTable = CopyHash(\%hVariableTable, $pVarTable);
	push (@aDeleteDelimiters, @$pDeleteDelimiters);
	push (@aKeepDelimiters, @$pKeepDelimiters);
	#
	# General phase
	#
	($pVarTable, $pDeleteDelimiters, $pKeepDelimiters) = ActinicOrder::DisplayGeneralPhase();
	%hVariableTable = CopyHash(\%hVariableTable, $pVarTable);
	push (@aDeleteDelimiters, @$pDeleteDelimiters);
	push (@aKeepDelimiters, @$pKeepDelimiters);
	#
	# Tax phase
	#
	($status, $sMessage, $pVarTable, $pDeleteDelimiters, $pKeepDelimiters) = ActinicOrder::DisplayTaxPhase();
	if ($status != $::SUCCESS)
		{
		return ($status, $sMessage);
		}
	%hVariableTable = CopyHash(\%hVariableTable, $pVarTable);
	push (@aDeleteDelimiters, @$pDeleteDelimiters);
	push (@aKeepDelimiters, @$pKeepDelimiters);

	($pDeleteDelimiters, $pKeepDelimiters) = ActinicOrder::ParseDelimiterStatus($::TAXCHARGEPHASE);
	push (@aDeleteDelimiters, @$pDeleteDelimiters);
	push (@aKeepDelimiters, @$pKeepDelimiters);
	#
	# Coupon code
	#
	$hVariableTable{$::VARPREFIX.'COUPONCODE'} = ACTINIC::EncodeText2($::g_PaymentInfo{'COUPONCODE'});
	if ($::g_BillContact{'AGREEDTANDC'})					# if the Terms and Conditions Box is checked leave it as checked
		{
		$hVariableTable{$::VARPREFIX.'INVOICEAGREETERMSCONDITIONS'} = 'CHECKED';
		}
	else
		{
		$hVariableTable{$::VARPREFIX.'INVOICEAGREETERMSCONDITIONS'} = '';
		}
	#
	# Display a warning at the top before any error message
	#
	my $sWarning = '<div align="center">' . ACTINIC::GetPhrase(-1, 1962) . ACTINIC::GetPhrase(-1, 1971) . ACTINIC::GetPhrase(-1, 1974);	# required colour span tag, actregular, bold
	if ($$::g_pSetupBlob{'CHECKOUT_NEEDS_TERMS_AGREED'}) # T&C flag is used			
		{
		$sWarning .= ACTINIC::GetPhrase(-1, 3024);		# warning to tick T&Cs and Confirm the payment afterwards
		}
	else
		{
		$sWarning .= ACTINIC::GetPhrase(-1, 3025);		# warning to Confirm the payment
		}
	$sWarning .= ACTINIC::GetPhrase(-1, 1975) . ACTINIC::GetPhrase(-1, 1970) . ACTINIC::GetPhrase(-1, 1970) . '</div><p>';	# </b></span></span>
		
	#
	# Any posible error
	#	
	if (length $hVariableTable{$::VARPREFIX.'ERROR'})
		{
		$sError .= ' ' . $hVariableTable{$::VARPREFIX.'ERROR'};	# if it has value already, then append this value to the new one.
		}
	$sError = ACTINIC::GroomError($sError);			# make the error look nice for the HTML
	$hVariableTable{$::VARPREFIX.'ERROR'} = $sWarning . $sError; # add the error message to the var list
	#
	# Generate the cart and display the page
	#
	my $sFileName = 'PPOrderConfirm.html';
	my $sPath = ACTINIC::GetPath();
	@Response = ActinicOrder::GenerateShoppingCartLines($pCartList, $::FALSE, [], $sFileName);
	if ($Response[0] != $::SUCCESS)
		{
		return (@Response);
		}
	@Response = ACTINIC::TemplateFile($sPath.$sFileName, \%hVariableTable); # make the substitutions
	if ($Response[0] != $::SUCCESS)
		{
		return (@Response);
		}
	#
	# clean up the links
	#
	my ($sDigest,$sBaseFile) = ACTINIC::CaccGetCookies();
	$sPath = ($sBaseFile) ? $sBaseFile : $::g_sContentUrl;
	@Response = ACTINIC::MakeLinksAbsolute($Response[2], $::g_sWebSiteUrl, $sPath);
	if ($Response[0] != $::SUCCESS)
		{
		return (@Response);
		}
	my ($sHTML) = $Response[2];
	#
	# remove unused form blocks
	#
	my ($sDelimiter);
	foreach $sDelimiter (@aDeleteDelimiters)			# for each delimited section that is to be deleted
		{
		$sHTML =~ s/$::DELPREFIX$sDelimiter(.*?)$::DELPREFIX$sDelimiter//gs;	# delete it (/s removes the \n limitation of .)
		}
	#
	# remove unused delimiters
	#
	foreach $sDelimiter (@aKeepDelimiters)				# for each delimiter that is not used
		{
		$sHTML =~ s/$::DELPREFIX$sDelimiter//gs;			# delete it
		}
	#
	# Set the invoice address country selector default
	#
	{
	my $sSelectName = 'LocationInvoiceCountry';
	my $sDefaultOption = $::g_LocationInfo{INVOICE_COUNTRY_CODE};
	$sHTML =~ s/(<\s*SELECT[^>]+?NAME\s*=\s*("|')?$sSelectName.+?)<OPTION\s+VALUE\s*=\s*("|')?$sDefaultOption("|')?\s*>/$1<option selected value="$sDefaultOption">/is;
	#
	# Set the delivery address country selector default
	#
	$sSelectName = 'LocationDeliveryCountry';
	$sDefaultOption = $::g_LocationInfo{DELIVERY_COUNTRY_CODE};
	$sHTML =~ s/(<\s*SELECT[^>]+?NAME\s*=\s*("|')?$sSelectName.+?)<OPTION\s+VALUE\s*=\s*("|')?$sDefaultOption("|')?\s*>/$1<option selected value="$sDefaultOption">/is;
	}
	#
	$::Session->SetPaypalOrderTotal($nTotal);
	ACTINIC::SaveSessionAndPrintPage($sHTML);
	return ($::SUCCESS, "")
	}

#######################################################
#
# CopyHash - merge two hashes into an array which can
#	 be used to create a hash
#
# Params:	0 - reference to the first hash
#				1 - reference to the secon hash
#
# Returns:	0 - resulting array
#
#######################################################

sub CopyHash
	{
	my $a1 = shift;
	my $a2 = shift;
	my (@a1, @a2) = (%$a1, %$a2);
	push (@a1, @a2);
	return (@a1);
	}

#***************************************************************
#
# ActinicPaypalConnection - package for common paypal communication
#
# Written by Zoltan Magyar
#
# Copyright (c) SellerDeck Limited 2007
#
#***************************************************************

package ActinicPaypalConnection;
require 5.002;

###############################################################
#
#  sub new - create a new connection object
#
#  Zoltan Magyar
#
#  Copyright (c) SellerDeck Limited (2007)
#
###############################################################

sub new
	{
	my $Proto = shift;
	my $Class = ref($Proto) || $Proto;
	my $Self  = {};
	bless ($Self, $Class);
	#
	# Init some members
	#
	$Self->{PARAMS} = {};								# list of parameters
	$Self->{TESTMODE} = $::PAYPAL_TESTMODE;						# test mode flag
	$Self->SetParam("VERSION", $::PAYPAL_API_VERSION);
	$Self->{PREAUTH} = ($bAuthorize ? "0" : "1");		# pre-authorize flag
	#
	# Set authentication parameters as they will be required all the time
	#
	$Self->{AUTH}->{"USER"} = $::PAYPAL_USER;
	$Self->{AUTH}->{"PWD"} = $::PAYPAL_PWD;
	$Self->{AUTH}->{"SIGNATURE"} =  $::PAYPAL_SIGNATURE;

	return $Self;
	}

###############################################################
#
#  SetParam - set parameters to transfer
#
#  Input:	[0] - parameter name
#				[1] - parameter value
#
#  Author: Zoltan Magyar
#
#  Copyright (c) SellerDeck Limited (2007)
#
###############################################################

sub SetParam
	{
	my $Self = shift @_;
	my $sParam = shift @_;
	my $sValue = shift @_;
	$Self->{PARAMS}->{$sParam} = $sValue;
	}

###############################################################
#
#  GetResponseHash - get the name/value pair hash of the response
#
#  Return:	[0] - reperence to the hash
#
#  Author: Zoltan Magyar
#
#  Copyright (c) SellerDeck Limited (2007)
#
###############################################################

sub GetResponseHash
	{
	my $Self = shift @_;
	return(\%{$Self->{RESPONSE_CONTENT_HASH}});
	}

###############################################################
#
#  GetParamString - get the parameter list as a name/value
#		pair list as required by paypal
#
#  Return:	[0] - the concatenated string parameter list
#
#  Author: Zoltan Magyar
#
#  Copyright (c) SellerDeck Limited (2007)
#
###############################################################

sub GetParamString
	{
	my $Self = shift @_;
	my $sParamString;
	my $sParam;
    foreach $sParam (keys %{$Self->{AUTH}})
        {
        my @aEncode = ACTINIC::EncodeText($Self->{AUTH}->{$sParam}, $::FALSE);
		$sParamString .= sprintf("%s=%s&", $sParam, $aEncode[1]);
        }
	#
	# Concatenate the params
	#
	foreach $sParam (keys %{$Self->{PARAMS}})
		{
        my @aEncode = ACTINIC::EncodeText($Self->{PARAMS}->{$sParam}, $::FALSE);
		$sParamString .= sprintf("%s=%s&", $sParam, $aEncode[1]);
		}
	#
	# Trim last &
	#
	$sParamString =~ s/\&$//;
	return($sParamString);
	}

###############################################################
#
#  SendRequest - send the request itself
#
#  Zoltan Magyar
#
#  Copyright (c) SellerDeck Limited (2007)
#
###############################################################

sub SendRequest
	{
	my $Self = shift @_;
	use Encode qw(decode encode);
	my $sServer = $::PAYPAL_LIVE_SERVER;			# default tot the live server
	#
	# Check if test mode and update the server address
	#
	if ($Self->{TESTMODE} == $::TRUE)
		{
		$sServer = $::PAYPAL_TEST_SERVER;
		$Self->SetParam("VERBOSITY", "MEDIUM");
		}
	$Self->SetParam("TESTMODE", $Self->{TESTMODE});
	#
	# Connect to paypal
	#
	srand();
	my $Random = rand();
	my $SSLConnection =  SSLConnection->new($sServer, $::PAYPAL_SERVER_PORT, "/nvp");
	$SSLConnection->SetRequestMethod("POST");
	$SSLConnection->SetHeaderValue("Content-Type", "text/namevalue");
	$SSLConnection->SetHeaderValue("X-VPS-REQUEST-ID", $Random);
	$SSLConnection->SetHeaderValue("X-VPS-VIT-CLIENT-CERTIFICATION-ID", "2c3b70aa5af7aded80d385183b2c673d");
	$SSLConnection->SetHeaderValue("X-VPS-CLIENT-TIMEOUT", $::PAYPAL_CONNECTION_TIMEOUT);
	if ($Self->{TESTMODE} == $::TRUE)
		{
		$SSLConnection->SetHeaderValue("Host", "pilot-payflowpro.paypal.com");
		}
	else
		{
		$SSLConnection->SetHeaderValue("Host", "payflowpro.paypal.com");
		}

	$SSLConnection->SendRequest($Self->GetParamString());

	if ($SSLConnection->GetConnectStatus() == $::FALSE)
		{
		return ($::FAILURE, "Couldn't connect to the Paypal web service. . Please try different payment method.", "");
		}
	#
	# Get the header as name-value pairs
	#
	$Self->{RESPONSE_HEADER_HASH} 		= $SSLConnection->GetHeaderHash();
	$Self->{_RESPONSE_HEADER_STRING}		= $SSLConnection->{_RESPONSE_HEADER_STRING};
	$Self->{_RESPONSE_CONTENT_STRING}	= $SSLConnection->{_RESPONSE_CONTENT_STRING};
	#
	# The check below is commented out becasue paypal's nvp API doesn't return the proper
	# content type indicator. So we can only assume it is name-value
	#
#	if ($Self->{RESPONSE_HEADER_HASH}->{"Content-type"} ne "text/namevalue")
#		{
#        ACTINIC::PrintPage($SSLConnection->GetResponseHeader() . "<BR>" . $Self->GetParamString()  . "<BR>" . $SSLConnection->GetResponseContent());
#		return ($::FAILURE, "Unexpected response format from the Paypal web service. Please try different payment method.", "");
#		}
	#
	# Now parse the content into key value pairs
	#
	my @arrContent = split(/&/, $SSLConnection->GetResponseContent());	# split into an array of key=value pairs
	my ($sLine, $sKey, $sValue);
	my %hashHeader;
	foreach $sLine (@arrContent)						# for each header line
		{
		if($sLine ne '')									# if there is something there
			{
			($sKey, $sValue) = split(/=/, $sLine); # split at the equal sign
			if($sValue)										# if there's a value
				{
				$Self->{RESPONSE_CONTENT_HASH}->{$sKey} = decode('UTF-8', ACTINIC::DecodeText($sValue, $ACTINIC::FORM_URL_ENCODED));	# set in the header hash
				}
			}
		}
	#
	# Dump response for debugging
	#
	#ACTINIC::PrintPage($SSLConnection->GetResponseHeader() . "<BR>" . $Self->GetParamString()  . "<BR>" . $SSLConnection->GetResponseContent());
	return ($::SUCCESS, "", "");
	}

###############################################################
#
#  GetRedirectHTML - get the HML code which redirects to the
#		paypal express checkout page
#
#	Input:	[0] - tkoen string to identify paypal transaction
#
#	Return:	[0] - the generated HTML
#
#  Zoltan Magyar
#
#  Copyright (c) SellerDeck Limited (2007)
#
###############################################################

sub GetRedirectHTML
	{
	my $Self 	= shift @_;
	my $sToken 	= shift @_;
	my $sServer = $::PAYPAL_IN_CONTEXT_CHECKOUT ? $::PAYPAL_LIVE_EC_SERVER_IN_CONTEXT : $::PAYPAL_LIVE_EC_SERVER;	# default to the live server
	#
	# Check if test mode and update the server address
	#
	if ($Self->{TESTMODE} == $::TRUE)
		{
		$sServer = $::PAYPAL_IN_CONTEXT_CHECKOUT ? $::PAYPAL_TEST_EC_SERVER_IN_CONTEXT : $::PAYPAL_TEST_EC_SERVER;
		}
	$sServer = sprintf($sServer, $sToken);

	my $sRedirectHTML = sprintf("<html><head><META HTTP-EQUIV=\"Refresh\"CONTENT=\"0;URL=%s\"></head>", $sServer);
	$sRedirectHTML .= sprintf("<body><a href=\"%s\"Click here if you are not redirected to PayPal within 5 seconds.</a></body>", $sServer);

	return $sRedirectHTML;
	}

###############################################################
#
#  GetCallbackURL - get the URL to be used for callbacks from paypal
#
#	Return:	[0] - the URL
#
#  Zoltan Magyar
#
#  Copyright (c) SellerDeck Limited (2007)
#
###############################################################

sub GetCallbackURL
	{
	#
	# Build the different callback URLs
	# Note that these should be based on SSL_CGI_URL if http+https
	# configuration is used because the CGI_URL contains the non secure
	# CGI URL in this case.
	#
	my		$sCgiUrl;
	#
	# SSL_USAGE 0 = not used, 1 = essential pages, 2 = whole site
	#
	if ($$::g_pSetupBlob{'SSL_USEAGE'} eq 1)
		{
		$sCgiUrl = $$::g_pSetupBlob{SSL_CGI_URL};
		}
	else
		{
		$sCgiUrl = $$::g_pSetupBlob{CGI_URL};
		}
	#
	# build the base URL for all other actions
	#
	my $sBaseUrl = sprintf("%sos%6.6d%s?%s",
			$sCgiUrl,
			$$::g_pSetupBlob{CGI_ID},
			$$::g_pSetupBlob{CGI_EXT},
			($::g_InputHash{SHOP} ? 'SHOP=' . ACTINIC::EncodeText2($::g_InputHash{SHOP}, $::FALSE) . '&' : ''));

	return $sBaseUrl;
	}

###############################################################
#
#  DoStartCheckout - send the start checkout request to paypal
#
#	Input:	The amount to be charged
#
#	Returns:	0	-	Status
#				1	-	Error message if any
#				2	-	Paypal token code in case of success (empty string otherwise)
#				3 	-	Paypal payer ID
#
# 	Expects: $::Session, $$::g_pCatalogBlob and $$::g_pSetupBlob
#
#  Copyright (c) SellerDeck Limited (2007) Zoltan Magyar
#
###############################################################

sub DoStartCheckout
	{
	my $Self 	= shift @_;
	my $nAmount = shift @_;
	#
	# Determine the CGI URL
	#
	my	$sCgiUrl = GetCallbackURL();
	#
	# Build the callback URL and the cancel URL (which is the last shop page)
	#
	my $sReturnURL = sprintf("%sACTION=PPCOMPLETECHECKOUT&SID=%s", $sCgiUrl, $::Session->GetSessionID());
	my $sCancelURL = $::Session->GetLastShopPage();

	$Self->SetParam("METHOD", 	    "SetExpressCheckout");		
	$Self->SetParam("PAYMENTREQUEST_0_AMT", 			$nAmount);
	$Self->SetParam("PAYMENTREQUEST_0_CURRENCYCODE", 	$$::g_pCatalogBlob{'SINTLSYMBOLS'});
	$Self->SetParam("RETURNURL", 	$sReturnURL);
	$Self->SetParam("CANCELURL", 	$sCancelURL);
	if ($bAuthorize)
		{
		$Self->SetParam("PAYMENTREQUEST_0_PAYMENTACTION", "Sale");
		}
	else
		{
		$Self->SetParam("PAYMENTREQUEST_0_PAYMENTACTION", "Authorization");
		}
	#
	# Add some other customization parameters if set
	#
	my @Response;
	if ($::PAYPAL_LOGO_IMAGE ne "")
		{
		$Self->SetParam("LOGOIMG", $::PAYPAL_LOGO_IMAGE);
		}
	if ($::PAYPAL_HEADER_IMAGE ne "")
		{
		$Self->SetParam("HDRIMG", $::PAYPAL_HEADER_IMAGE);
		}
	if ($::PAYPAL_BRAND_NAME ne "")
		{		
		$Self->SetParam("BRANDNAME", $::PAYPAL_BRAND_NAME);
		}
	$Self->SetParam("SOLUTIONTYPE ", $::PAYPAL_SOLUTION_TYPE);
	$Self->SetParam("LANDINGPAGE", $::PAYPAL_LANDING_PAGE);
	@Response = AddLineItems($Self);				# make sure that order lines get displayed
	if ($Response[0] != $::SUCCESS)
		{
		return (@Response);
		}
	$Self->SendRequest();

	my $sAck = $Self->{RESPONSE_CONTENT_HASH}->{ACK};
	if ($sAck =~ /^failure/i)
		{
		return($::FAILURE, $Self->{RESPONSE_CONTENT_HASH}->{L_LONGMESSAGE0}, "", "");
		}
	#
	# Save the token
	#
	my $sToken = $Self->{RESPONSE_CONTENT_HASH}->{"TOKEN"};
	my $sPayerID = $Self->{RESPONSE_CONTENT_HASH}->{"PAYERID"};
	return ($::SUCCESS, "", $sToken, $sPayerID);
	}

###############################################################
#
#  DoExpressCheckoutPayment - send the do payment request to paypal
#
#	Input:	The amount to be charged
#
#	Returns:	Paypal token code in case of success (empty string otherwise)
#
# 	Expects: $::Session, $$::g_pCatalogBlob and $$::g_pSetupBlob
#
#  Copyright (c) SellerDeck Limited (2007) Zoltan Magyar
#
###############################################################

sub DoExpressCheckoutPayment
	{
	my $Self 	= shift @_;
	my $nAmount = shift @_;
	my ($sToken, $sPayerID) = $::Session->GetPaypalProIDs();
	#
	# Set up params for paypal and send the request
	#
	$Self->SetParam("BUTTONSOURCE",	$::BNID_EC);
	if ($bAuthorize)
		{
		$Self->SetParam("PAYMENTREQUEST_0_PAYMENTACTION", "Sale");
		}
	else
		{
		$Self->SetParam("PAYMENTREQUEST_0_PAYMENTACTION", "Authorization");
		}
	$Self->SetParam("METHOD",		"DoExpressCheckoutPayment");			# sales
	$Self->SetParam("PAYMENTREQUEST_0_AMT", $nAmount);
	$Self->SetParam("PAYMENTREQUEST_0_CURRENCYCODE", $$::g_pCatalogBlob{'SINTLSYMBOLS'});
	$Self->SetParam("TOKEN", 		$sToken);
	$Self->SetParam("PAYERID", 	$sPayerID);
	@Response = AddLineItems($Self);					# make sure that order lines get displayed
	if ($Response[0] != $::SUCCESS)
		{
		return (@Response);
		}
	my @Response = $Self->SendRequest();

	my $sAck = $Self->{RESPONSE_CONTENT_HASH}->{ACK};
	if ($sAck =~ /^failure/i)
		{
		#
		# Look for a funding failure
		#
		my $nErr = 0;
		my $sKey;
		while ($nErr < 100)								# should never be this many errors on one transaction
			{
			$sKey = sprintf("L_ERRORCODE%s", $nErr);
			if (!defined $Self->{RESPONSE_CONTENT_HASH}->{$sKey})
				{
				#
				# If we didn't find a funding error then just report the first error
				#
				return($::FAILURE, $Self->{RESPONSE_CONTENT_HASH}->{L_LONGMESSAGE0}, $Self->{RESPONSE_CONTENT_HASH}->{L_ERRORCODE0});		
				}
			if ($Self->{RESPONSE_CONTENT_HASH}->{$sKey} eq $::PAYPAL_FUNDING_FAILURE)
				{
				#
				# We have a funding error
				#
				my $sMsg = sprintf("L_LONGMESSAGE%s", $sKey);
				return($::FAILURE, $Self->{RESPONSE_CONTENT_HASH}->{$sMsg}, $Self->{RESPONSE_CONTENT_HASH}->{$sKey});		
				}
			$nErr++;
			}
		}

	return @Response;
	}

###############################################################
#
#  AddLineItems - Adds order line items to express checkout
#
#	Input:	$Self
#
#	Returns:	Success or failure
#
#  Copyright (c) SellerDeck Limited (2014) Zsolt Rethy
#
###############################################################

sub AddLineItems
	{
	my $Self 	= shift @_;
	#
	# Process and add line items
	#
	my (@Response) = $::Session->GetCartObject();
	if ($Response[0] != $::SUCCESS)                                # general error
			{
			return (@Response);
			}
	my $pCartObject = $Response[2];
	#
	# Summarize the order, get shipping, handling and tax information
	#
	#
	@Response = $pCartObject->SummarizeOrder($::TRUE);		# calculate the order total
	if ($Response[0] != $::SUCCESS)
		{
		return (@Response);
		}
	#
	# Sum totals first
	#
	my ($Ignore0, $Ignore1, $nSubTotal, $nShipping, $nTax1, $nTax2, $nTotal, $nShippingTax1, $nShippingTax2, $nHandling, $nHandlingTax1, $nHandlingTax2) = @Response;
	
	my $pCartList = $pCartObject->GetCartList();
	my ($pOrderDetail, $pProduct);
	my ($Status, $Message, $sSectionBlobName);
	my ($nProductPrice, $nPrice, $rarrCurTaxBands, $rarrDefTaxBands, @aProductTax);
	my $n = 0;
	#
	# Now iterate through the individual orderlines
	#
	my ($parrAdjustments, $parrAdjustDetails);
	my $nLine = 0;
	foreach $pOrderDetail (@$pCartList)
		{		
		my ($sSectionBlobName);
		($Status, $Message, $sSectionBlobName) = ACTINIC::GetSectionBlobName($$pOrderDetail{SID}); # retrieve the blob name
		if ($Status == $::FAILURE)
			{
			return (@Response);
			}
		#
		# locate this product's object.
		#
		@Response = ACTINIC::GetProduct($$pOrderDetail{"PRODUCT_REFERENCE"}, $sSectionBlobName,
												  ACTINIC::GetPath());	# get this product object
		($Status, $Message, $pProduct) = @Response;
		if ($Status != $::SUCCESS)					# the item has been removed from the catalog or other error occurred
			{
			return ($::FAILURE, $Message);			# do not display the cart
			}
		$Self->SetParam("L_PAYMENTREQUEST_0_NAME$n", $$pProduct{"NAME"});
		$Self->SetParam("L_PAYMENTREQUEST_0_NUMBER$n", $$pOrderDetail{"PRODUCT_REFERENCE"});
		
		($Status, $Message, $nProductPrice, $nPrice,
			$rarrCurTaxBands, $rarrDefTaxBands,	@aProductTax) = $pCartObject->GetCartItemPrice($pOrderDetail);
		if ($Status == $::FAILURE)				# general error
			{
			return ($Status, $Message, "", "");		# return error
			}		
		$Self->SetParam("L_PAYMENTREQUEST_0_AMT$n", FormatAmount($nPrice));
		$Self->SetParam("L_PAYMENTREQUEST_0_QTY$n", $$pOrderDetail{"QUANTITY"});		
		my $sDescription;
		#
		# Collect variants in the cart if any
		#
		if($pProduct->{COMPONENTS})						# For all components/attributes of the product
			{
			my $lstVariants = ActinicOrder::GetCartVariantList($pOrderDetail);
			my ($c, %Component);
			foreach $c (@{$pProduct->{COMPONENTS}})
				{
				($Status, %Component) = ActinicOrder::FindComponent($c, $lstVariants);				
				if ($Status != $::SUCCESS)
					{
					return ($Status, $Component{text}, "", "");
					}
				my $sCompDesc = ($Component{text} ne "") ? $Component{text} : $c->[$::CBIDX_NAME];
				$sDescription .= (($sDescription ne "") ? ", " : "") . $sCompDesc;				
				}			
			}
		$Self->SetParam("L_PAYMENTREQUEST_0_DESC$n", substr($sDescription, 0, 127));
		#
		# Add adjustments as orderlines in order to get the totals right for PP
		#			
		$parrAdjustments = $pCartObject->GetProductAdjustments($nLine);		
		foreach $parrAdjustDetails (@$parrAdjustments)
			{
			$n++;			
			$Self->SetParam("L_PAYMENTREQUEST_0_NAME$n", $parrAdjustDetails->[$::eAdjIdxProductDescription]);
			$Self->SetParam("L_PAYMENTREQUEST_0_NUMBER$n", $parrAdjustDetails->[$::eAdjIdxProductRef]);			
			$Self->SetParam("L_PAYMENTREQUEST_0_DESC$n", "");
			$Self->SetParam("L_PAYMENTREQUEST_0_AMT$n", FormatAmount($parrAdjustDetails->[$::eAdjIdxAmount]));
			$Self->SetParam("L_PAYMENTREQUEST_0_QTY$n", 1);			
			}
		$n++;
		$nLine++;
		}	
	#
	# Add any order adjustments
	#
	my $nOrderAdjustments = 0;
	$parrAdjustments = $pCartObject->GetOrderAdjustments();	
	push @$parrAdjustments, @{$pCartObject->GetFinalAdjustments()};
	foreach $parrAdjustDetails (@$parrAdjustments)
		{		
		$Self->SetParam("L_PAYMENTREQUEST_0_NAME$n", $parrAdjustDetails->[$::eAdjIdxProductDescription]);
		$Self->SetParam("L_PAYMENTREQUEST_0_NUMBER$n", "");			
		$Self->SetParam("L_PAYMENTREQUEST_0_DESC$n", "");
		$Self->SetParam("L_PAYMENTREQUEST_0_AMT$n", FormatAmount($parrAdjustDetails->[$::eAdjIdxAmount]));
		$Self->SetParam("L_PAYMENTREQUEST_0_QTY$n", 1);		
		$nOrderAdjustments += $parrAdjustDetails->[$::eAdjIdxAmount];
		$n++;							# increment the sequence number						# increment the sequence number
		}
	# 
	# Add order totals
	#
	my $nTaxTotal = 0;
	my $nItemAmount = $nSubTotal + $nOrderAdjustments;
	if (!ActinicOrder::PricesIncludeTaxes())# no tax passed on if order lines already including tax
		
		{
		$nTaxTotal = $nTax1 + $nTax2;
		}	
	elsif (($nTax1 + $nTax2) < 0)					# negative tax that means we have to substract it, PP doesn't accept a negative tax line
		{
		$Self->SetParam("L_PAYMENTREQUEST_0_NAME$n", "Exempted Tax");
		$Self->SetParam("L_PAYMENTREQUEST_0_NUMBER$n", "");			
		$Self->SetParam("L_PAYMENTREQUEST_0_DESC$n", "");
		$Self->SetParam("L_PAYMENTREQUEST_0_AMT$n", FormatAmount($nTax1 + $nTax2));
		$Self->SetParam("L_PAYMENTREQUEST_0_QTY$n", 1);		
		$nItemAmount += ($nTax1 + $nTax2);		# substract tax from item amount (subtotal) as it counts to the orderlines
		}	
	$Self->SetParam("PAYMENTREQUEST_0_ITEMAMT", FormatAmount($nItemAmount)); # subtotal, adjustments and exempted tax substracted
	$Self->SetParam("PAYMENTREQUEST_0_TAXAMT", FormatAmount($nTaxTotal));
	$Self->SetParam("PAYMENTREQUEST_0_SHIPPINGAMT", $$::g_pSetupBlob{'MAKE_SHIPPING_CHARGE'} ? FormatAmount($nShipping) : 0.00);	
	$Self->SetParam("PAYMENTREQUEST_0_SHIPDISCAMT", 0.00);
	$Self->SetParam("PAYMENTREQUEST_0_HANDLINGAMT", $$::g_pSetupBlob{'MAKE_HANDLING_CHARGE'} ? FormatAmount($nHandling) : 0.00);
	return ($::SUCCESS, "", "", "");
	}
	
###############################################################
#
#  FormatAmount - Makes sure that the amount is sent with the
#	proper number of digits
#
#	Input:	the price to format
#
#	Returns: formatted price
#
#  Copyright (c) SellerDeck Limited (2014) Zsolt Rethy
#
###############################################################
	
sub FormatAmount
	{	
	#
	# Convert Actinic price before sending the request
	#
	my $nPrice = shift;	
	$nPrice += ($nPrice == abs($nPrice)) ? 0.5 : -0.5;	
	$nPrice = int($nPrice);						# be sure that Actinic price is an integer	
	my $dPrice = $nPrice / (10 ** $$::g_pCatalogBlob{"ICURRDIGITS"});	# convert the internal format to the currency float	
	return $dPrice;
	}
	
###############################################################
#
#  StartOverCheckout - Start checkout again after getting
#	an error, being able to select another card
#
#	Returns: The redirect HTML
#
#  Copyright (c) SellerDeck Limited (2014) Zsolt Rethy
#
###############################################################
	
sub StartOverCheckout
	{
	my $Self 	= shift @_;
	my ($sToken, $sPayerID) = $::Session->GetPaypalProIDs();
	if ($sToken eq '')
		{
		return($::FAILURE, '');
		}	
	#
	# Now redirect to PayPal
	#	
	my $sRedirectHTML = $Self->GetRedirectHTML($sToken);
	
	return($::SUCCESS, $sRedirectHTML);
	}