// norpricesupport.js V5.12 ECB 
var np_vatrate = 1.2;
if ( np_mainsymbol == '$' ) np_mainsymbol = '\\' + np_mainsymbol;					// escape dollar
var np_pricepattern = new RegExp(np_mainsymbol + '\+?[\\d,]+(\\.\\d\\d)?', 'g');			// general text match - e.g. 10 12.34 1,234.56 with optional leading +
var np_pattern = new RegExp('(.*)(' + np_mainsymbol + ')([\\d,]+\\.\\d\\d)(.*)');			// dynamic price match - e.g. 12.34 or 1,234.56 surrounded by other text
var np_choicealtprice = false;
var np_isoname = '';
var np_exchange;
var np_ecodes=new Object();
np_ecodes['EUR'] = {code:'EUR', rate:'1', lname:'European Euro'};

function getexchangeratefromcookie(){
	var allcookies = document.cookie;
	var pos = allcookies.indexOf('destcurr=');
	if ( pos != -1 )
		{
		var start = pos + 9;
		var end = allcookies.indexOf(';', start);
		if ( end == -1 ) end = allcookies.length;
		var value = unescape(allcookies.substring(start,end));
		var bits = value.split(':');
		np_isoname = bits[0];
		var base = bits[1];
		var dest = bits[2];
		np_exchange = base / dest;
		np_choicealtprice = ( (np_isoname != np_hidemain) && (np_isoname != np_hidealt) && (dest > 0) );
		}
}


//function fb_show(link, height, width){	// open FancyBox dropdown
//	$.fancybox({type:'iframe', href:link, width:width, height:height, onClosed:norpricereload});
// 	$.fancybox.open({type:'iframe', src:link, iframe:{css:{width:width + 'px', height:height + 'px'}}, afterClose:norpricereload});
//}

// Chat GPT patched for Fancybox 4 + revised to pass width and height from fb show



function fb_show(link, height, width) {
    Fancybox.show([{
        src: link,
        type: "iframe",
        customClass: "np-fancybox"
    }], {
        autoSize: false,
        dragToClose: false,
        width: width,
        height: height,
        iframe: {
            preload: false,
            attr: {
                style: 'width:' + width + 'px;height:' + height + 'px;max-width:' + width + 'px;max-height:' + height + 'px;border:0;'
            }
        },
        on: {
            destroy: norpricereload
        }
    });
}



// deal with Fancybox window closing
//$(window).on("message", function(e) 
//		{
//		if (e.originalEvent.data == 'fancy_close') $.fancybox.close();
//		}
//	);


// Chat GPT edit for Fancybox 4/5

// Close Fancybox when we receive message from iframe (norpricepopup.html)
window.addEventListener("message", function(e) {
    if (e.data === 'fancy_close') {
        const instance = Fancybox.getInstance();
        if (instance) {
            instance.close();
        } else {
            console.warn("No Fancybox instance found.");
        }
    }
}, false);



function norpricepopup(){		// a currency link has been clicked
	var arg = '';
	if ( arguments.length == 1 ) 
		{
		$( ".npinlinedd" ).prop('selectedIndex', 0);			// reset any norprice drop-downs	
		return silentlysetcurrency(arguments[0]);			// single currency requested
		}
		fb_show(np_prevloc + 'norpricepopup' + '.html?' + arg + 'hidemain=' + np_hidemain + '&showonly=' + np_showonly + '&nplink=' + np_nplink, 180, 470);

}	

function CommaFormatted(num){		// comma every 3 places
	var sep = ',';
	num = num.toString().split('').reverse().join('');					// reverse number
	num = num.replace(/(\d\d\d)(?=\d)(?!\d*\.)/g,'$1' + sep);				// add commas
	return num.split('').reverse().join('');						// reverse number back;
}

function getalt(price, formatted){	// return converted price with optional HTML formatting
	var prefix = formatted ? ' <span class="altprice">' : ' ';  				// see if we want HTML formatting
	var suffix = formatted ? '</span>' : '';                  				//    or just plain text
	var sep = formatted ? '&nbsp;' : ' '; 	                 				// separator between price and currency
	var optplus = price.match(/\+/) ? '+' : '';						// remember if leading "+"
	price = price.replace(/&#44;|,/g,"");							// remove all commas
	price = price.replace(/&#46;/g,".");    						// restore decimal point
	var pbits = price.match(/(-?\d+(\.\d\d)?)/);						// now look for first [-]n.nn 
	if ( pbits != null )
		{ 
		var numprice = pbits[1];
		var altprice = numprice * np_exchange;
		// remove comment below to show non EU currencies ex-VAT throughout site 
		//   if ( 'EUR-DKK-SEK-GBP'.indexOf(np_isoname) == -1 ) altprice = altprice / np_vatrate;
		// OR remove comment below to show selected currencies (currently USD) ex-VAT but not in Cart and Checkout
		// if ( ('USD'.indexOf(np_isoname) > -1) && (location.href.match(/cgi-bin\/(ca0|os0|cm0)/) == null) ) altprice = altprice / np_vatrate;
		if ( np_exchange > np_hidefraction )
			{
			return prefix + '(' + optplus + CommaFormatted(Math.round(altprice)) + sep + np_isoname + ')' + suffix;
			}
		else
			{
			return prefix + '(' + optplus + CommaFormatted(altprice.toFixed(2)) + sep + np_isoname + ')' + suffix;
			}
		}
	return ' --- ';  // should never get here but just in case...
}

// V2 onwards - jQuery method
function replaceprice(match){			// called when pricepattern match is found - return styled text
	return match + getalt(match, true);
}

function replacepriceplain(match){		// called when pricepattern match is found - return plain text
	return match + getalt(match, false);
}	

function pricelabels(){			// called when DOM ready or popup closes
	getexchangeratefromcookie();								// see if exchange rate is set
	if ( ! np_choicealtprice ) return;								// no rate found so exit
	$( "body :not(option,input,textarea,script,form,.noconvert)" ).replaceText(np_pricepattern, replaceprice);// try convert on every likely text node
	$( "option" ).not('.noconvert').replaceText(np_pricepattern, replacepriceplain);		// and drop-downs	
}

function norpricereload(){		// called when popup closes
	$("span.altprice").remove();								// remove any existing inline prices
	pricelabels();
}

$(document).ready(function() { 		// do convert on page reload
	pricelabels(); 
});

// new code for setting rate without popup
// Chat GPT edit
// Called from norpricepopup.html via setTimeout after 200ms
function setcookieandreload(newcurr) {
    if (np_ecodes[newcurr]) {
        document.cookie = "destcurr=" + escape(newcurr + ':' + np_ecodes[newcurr].rate + ':' + np_ecodes[np_hidemain].rate) + '; path=/';
        norpricereload();
        setTimeout(function () {
            window.parent.postMessage('fancy_close', '*');
        }, 1200); // 200ms delay before closing modal
        return;
    }
    alert('Unknown currency ' + newcurr);
}


function silentlysetcurrency(newcurr){		// load a preselected currency without a popup
	jQuery.ajax({
		async:		false,
		type:		'GET',
		url:		np_nplink + "norpricejs.php",
		data:		null,
		success:	function(){setcookieandreload(newcurr);},
		dataType:	'script'
	    });
}

function populatedropdownonfocus(sel){		// dynamically load inline drop-down with options when it is first selected
	if( (location.href.indexOf('PreviewHTML') > -1) || ($(sel).children('option').length > 1) ) return;	// abandon on Preview or drop down already populated
	jQuery.ajax({
		async:		false,
		type:		'GET',
		url:		np_nplink + "norpricejs.php",
		data:		null,
		success:	function()
					{
					// preserve drop downs initial value
					var options = ['<option value="">' + $(sel).children('option:first').text() + '</option>'];
					for ( var currency in np_ecodes )
						{
						var ecode = np_ecodes[currency].code;
						if ( (np_showonly == '') || (np_showonly.indexOf(ecode) > -1) )
							{
							optcode = '<option class="npinlinedd"';
							if ( ecode == np_isoname ) optcode += ' selected';
							optcode += ' value="' + ecode + '">';
							optcode += ecode + ' ' + np_ecodes[currency].lname;
							optcode += '</option>';
							options.push(optcode);
							}
						}
					$(sel).html(options.join(''));	
					},
		dataType:	'script'
	    });
}

function npinlinedropdown(sel){			// called from inline drop-down list
	if( location.href.indexOf('PreviewHTML') > -1 ) return;
	var val = sel.options[sel.selectedIndex].value;
	if( val != '' ) silentlysetcurrency(val);
}

// now code to deal with dynamic prices
function cnvtext(text, formatted){
	if ( ! np_choicealtprice ) return text;							// no conversion needed
	//
	// this routine could be changed to allow for different ways of including the option price.
	//
	text = $('<div/>').html(text).text();							// remove SellerDeck escaping
	val = text.match(np_pattern);								// have we currency symbol then n.nn
	if ( val != null )
		{
		var sign = ''
		var spos = val[1].match(/([-\+])$/);						// see if there was a + or -
		if ( spos != null ) sign = spos[1];
		var thisval = sign + val[3].replace(/,/g,'');					// create the optionally signed value
		if ( isNaN(thisval) ) return text;						// ignore invalid numbers
		return val[1] + val[2] + val[3] + getalt(thisval, formatted) + val[4];		// return potentially converted text
		}
	return text;										// return unaltered text
}

// Redefine SD 2013 dynamic pricing to include NorPrice

function FormatPrices(nPrice){
	var arrPrices = [];
	for (var i = 0; i < g_oConfig.arrCurrs.length; i++)
		{
		var oCurr = g_oConfig.arrCurrs[i];
		arrPrices.push(FormatPrice(nPrice, oCurr));
		}
	if (arrPrices.length == 1)
		{
		return cnvtext(arrPrices[0], true);
		}
	else
		{ 
		return Sprintf(g_oConfig.sPriceFmt, cnvtext(arrPrices[0], true), arrPrices[1]);
		} 
}

// The text replacer

/*!
 * jQuery replaceText - v1.1 - 11/21/2009
 * http://benalman.com/projects/jquery-replacetext-plugin/
 * 
 * Copyright (c) 2009 "Cowboy" Ben Alman
 * Dual licensed under the MIT and GPL licenses.
 * http://benalman.com/about/license/
 */

// Script: jQuery replaceText: String replace for your jQueries!
//
// *Version: 1.1, Last updated: 11/21/2009*
// 
// Project Home - http://benalman.com/projects/jquery-replacetext-plugin/
// GitHub       - http://github.com/cowboy/jquery-replacetext/
// Source       - http://github.com/cowboy/jquery-replacetext/raw/master/jquery.ba-replacetext.js
// (Minified)   - http://github.com/cowboy/jquery-replacetext/raw/master/jquery.ba-replacetext.min.js (0.5kb)
// 
// About: License
// 
// Copyright (c) 2009 "Cowboy" Ben Alman,
// Dual licensed under the MIT and GPL licenses.
// http://benalman.com/about/license/
// 
// About: Examples
// 
// This working example, complete with fully commented code, illustrates one way
// in which this plugin can be used.
// 
// replaceText - http://benalman.com/code/projects/jquery-replacetext/examples/replacetext/
// 
// About: Support and Testing
// 
// Information about what version or versions of jQuery this plugin has been
// tested with, and what browsers it has been tested in.
// 
// jQuery Versions - 1.3.2, 1.4.1
// Browsers Tested - Internet Explorer 6-8, Firefox 2-3.6, Safari 3-4, Chrome, Opera 9.6-10.1.
// 
// About: Release History
// 
// 1.1 - (11/21/2009) Simplified the code and API substantially.
// 1.0 - (11/21/2009) Initial release

(function($){
  '$:nomunge'; // Used by YUI compressor.
  
  // Method: jQuery.fn.replaceText
  // 
  // Replace text in specified elements. Note that only text content will be
  // modified, leaving all tags and attributes untouched. The new text can be
  // either text or HTML.
  // 
  // Uses the String prototype replace method, full documentation on that method
  // can be found here: 
  // 
  // https://developer.mozilla.org/En/Core_JavaScript_1.5_Reference/Objects/String/Replace
  // 
  // Usage:
  // 
  // > jQuery('selector').replaceText( search, replace [, text_only ] );
  // 
  // Arguments:
  // 
  //  search - (RegExp|String) A RegExp object or substring to be replaced.
  //    Because the String prototype replace method is used internally, this
  //    argument should be specified accordingly.
  //  replace - (String|Function) The String that replaces the substring received
  //    from the search argument, or a function to be invoked to create the new
  //    substring. Because the String prototype replace method is used internally,
  //    this argument should be specified accordingly.
  //  text_only - (Boolean) If true, any HTML will be rendered as text. Defaults
  //    to false.
  // 
  // Returns:
  // 
  //  (jQuery) The initial jQuery collection of elements.
  
  $.fn.replaceText = function( search, replace, text_only ) {
    return this.each(function(){
       var node = this.firstChild,
        val,
        new_val,
        
        // Elements to be removed at the end.
        remove = [];
      
      // Only continue if firstChild exists.
      if ( node ) {
     
        // Loop over all childNodes.
        do {
          
          // Only process text nodes.
          if ( node.nodeType === 3 ) {
            // The original node value.
            val = node.nodeValue;
          
            // The new value.
            new_val = val.replace( search, replace );
            
            // Only replace text if the new value is actually different!
            if ( new_val !== val ) {
              
              if ( !text_only && /</.test( new_val ) ) {
                // The new value contains HTML, set it in a slower but far more
                // robust way.
                $(node).before( new_val );
                
                // Don't remove the node yet, or the loop will lose its place.
                remove.push( node );
              } else {
                // The new value contains no HTML, so it can be set in this
                // very fast, simple way.
                node.nodeValue = new_val;
              }
            }
          }
          
        } while ( node = node.nextSibling );
      }
      
      // Time to remove those elements!
      remove.length && $(remove).remove();
    });
  };  
})(jQuery);


